/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.registry;

import it.geosolutions.imageio.registry.ImageIOEXTRegistry;
import it.geosolutions.imageio.registry.PartiallyOrderedSet;
import it.geosolutions.imageio.registry.RegisterablePlugin;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class SubTypeRegistry {
    ImageIOEXTRegistry registry;
    Class<?> subType;
    final PartiallyOrderedSet<Object> partiallyOrderedSet = new PartiallyOrderedSet();
    final Map<Class<?>, Object> map = new HashMap();

    public SubTypeRegistry(ImageIOEXTRegistry registry, Class<?> subType) {
        this.registry = registry;
        this.subType = subType;
    }

    public synchronized boolean registerSPI(Object spi) {
        boolean exists;
        Object provider = this.map.get(spi.getClass());
        boolean bl = exists = provider != null;
        if (exists) {
            this.deregisterSPI(provider);
        }
        this.map.put(spi.getClass(), spi);
        this.partiallyOrderedSet.add(spi);
        if (spi instanceof RegisterablePlugin) {
            RegisterablePlugin plugin = (RegisterablePlugin)spi;
            plugin.onRegistration(this.registry, this.subType);
        }
        return !exists;
    }

    public synchronized boolean deregisterSPI(Object spi) {
        Object plugin = this.map.get(spi.getClass());
        if (spi == plugin) {
            this.map.remove(spi.getClass());
            this.partiallyOrderedSet.remove(spi);
            if (spi instanceof RegisterablePlugin) {
                RegisterablePlugin rs = (RegisterablePlugin)spi;
                rs.onDeregistration(this.registry, this.subType);
            }
            return true;
        }
        return false;
    }

    public boolean isRegistered(Object spi) {
        Object plugin = this.map.get(spi.getClass());
        return plugin == spi;
    }

    public synchronized boolean setOrder(Object firstSpi, Object secondSpi) {
        return this.partiallyOrderedSet.setOrder(firstSpi, secondSpi);
    }

    public synchronized boolean unsetOrder(Object firstSpi, Object secondSpi) {
        return this.partiallyOrderedSet.clearOrder(firstSpi, secondSpi);
    }

    public synchronized Iterator<Object> getSPIs(boolean sorting) {
        return sorting ? this.partiallyOrderedSet.iterator() : this.map.values().iterator();
    }

    public synchronized void clear() {
        Iterator<Object> iter = this.map.values().iterator();
        while (true) {
            if (!iter.hasNext()) {
                this.partiallyOrderedSet.clear();
                return;
            }
            Object provider = iter.next();
            iter.remove();
            if (!(provider instanceof RegisterablePlugin)) continue;
        }
    }

    public synchronized void finalize() {
        this.clear();
    }
}

