/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Modifier;
import org.python.core.Py;
import org.python.core.PyInstance;
import org.python.core.PyJavaClass;
import org.python.core.PyObject;
import org.python.core.PyReflectedConstructor;
import org.python.core.PyString;

public class PyJavaInstance
extends PyInstance
implements Externalizable {
    public PyJavaInstance() {
    }

    public PyJavaInstance(PyJavaClass pyJavaClass) {
        super(pyJavaClass, null);
    }

    public PyJavaInstance(Object object) {
        super(PyJavaClass.lookup(object.getClass()), null);
        this.javaProxy = object;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        this.javaProxy = object = objectInput.readObject();
        this.instclass = PyJavaClass.lookup(object.getClass());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.javaProxy);
    }

    public void __init__(PyObject[] pyObjectArray, String[] stringArray) {
        PyReflectedConstructor pyReflectedConstructor;
        Class clazz = this.instclass.proxyClass;
        if (clazz != null) {
            int n = clazz.getModifiers();
            if (Modifier.isInterface(n)) {
                throw Py.TypeError("can't instantiate interface (" + this.instclass.__name__ + ")");
            }
            if (Modifier.isAbstract(n)) {
                throw Py.TypeError("can't instantiate abstract class (" + this.instclass.__name__ + ")");
            }
        }
        if ((pyReflectedConstructor = ((PyJavaClass)this.instclass).__init__) == null) {
            throw Py.TypeError("no public constructors for " + this.instclass.__name__);
        }
        pyReflectedConstructor.__call__((PyObject)this, pyObjectArray, stringArray);
    }

    protected void noField(String string, PyObject pyObject) {
        throw Py.TypeError("can't set arbitrary attribute in java instance: " + string);
    }

    protected void unassignableField(String string, PyObject pyObject) {
        throw Py.TypeError("can't assign to this attribute in java instance: " + string);
    }

    public int hashCode() {
        if (this.javaProxy != null) {
            return this.javaProxy.hashCode();
        }
        return super.hashCode();
    }

    public PyObject _is(PyObject pyObject) {
        if (pyObject instanceof PyJavaInstance) {
            return this.javaProxy == ((PyJavaInstance)pyObject).javaProxy ? Py.One : Py.Zero;
        }
        return Py.Zero;
    }

    public PyObject _isnot(PyObject pyObject) {
        return this._is(pyObject).__not__();
    }

    public int __cmp__(PyObject pyObject) {
        if (!(pyObject instanceof PyJavaInstance)) {
            return -2;
        }
        PyJavaInstance pyJavaInstance = (PyJavaInstance)pyObject;
        if (this.javaProxy.equals(pyJavaInstance.javaProxy)) {
            return 0;
        }
        return -2;
    }

    public PyString __str__() {
        return new PyString(this.javaProxy.toString());
    }

    public PyString __repr__() {
        return this.__str__();
    }

    public void __delattr__(String string) {
        throw Py.TypeError("can't delete attr from java instance: " + string);
    }
}

