package org.openjump.sextante.gui.additionalResults;

import java.util.ArrayList;

import javax.swing.JInternalFrame;

import org.openjump.sextante.core.ObjectAndDescription;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;

/**
 * This class stores results generated by SEXTANTE geoalgorithms that are
 * neither layers nor tables (i.e text results and charts). They are all stored
 * as java Component objects, so they can be shown in a dialogs. Charts do not
 * have to be modified, since they already extend the Component class. Text
 * strings should be put into some kind of panel or TextArea. This is not done
 * by this class, but should be done by the corresponding post-process task (see
 * {IPostProcessFactory})
 *
 * @author volaya
 *
 *         This class is a refactoring of Sextante
 *         es.unex.sextante.gui.additionalResults.AdditionalResults It has been
 *         extended to OpenJUMP output results objects. Methods to open a frame
 *         to show results are added to this class.
 * 
 * @author Giuseppe Aruta [2017-12-12]
 */
public class AdditionalResults {

    public static ArrayList<ObjectAndDescription> m_Components = new ArrayList<ObjectAndDescription>();

    /**
     * Shows a panel with results, only if there is at least one of them,
     */
    public static void showPanel() {

        if (m_Components == null || m_Components.size() == 0) {
            return;
        }

        final AdditionalResultsFrame additionalResults = new AdditionalResultsFrame(
                m_Components);

        additionalResults.setVisible(true);

        // SextanteGUI.getGUIFactory().showAdditionalResultsDialog(m_Components);

    }

    /**
     * Returns the list of results as a list of components
     *
     * @return the list of results
     */
    public static ArrayList<ObjectAndDescription> getComponents() {

        return m_Components;

    }

    /**
     * Adds a new component "ObjectAndDescription" and show it into the frame
     * 
     *
     * @param oad
     *            a result and its description, to be shown in the corresponding
     *            panel
     */
    public static void addComponent(final ObjectAndDescription oad) {

        m_Components.add(oad);

    }

    /**
     * Adds a new component "ObjectAndDescription" and show it into the frame
     *
     * @param oad
     *            a result and its description, to be shown in the corresponding
     *            panel
     */

    public static void addComponentAndShow(final ObjectAndDescription oad) {

        m_Components.add(oad);
        for (final JInternalFrame iFrame : wFrame.getInternalFrames()) {
            if (iFrame instanceof AdditionalResultsFrame) {

                iFrame.toFront();
                return;

            }
        }
        final AdditionalResultsFrame additionalResultsFrame = new AdditionalResultsFrame(
                m_Components);

        // additionalResults.setVisible(true);
        wFrame.addInternalFrame(additionalResultsFrame, true, true);
    }

    /**
     * Removes a component "ObjectAndDescription" from the ArrayList
     *
     * @param oad
     *            The result to remove
     */
    public static void removeComponent(final ObjectAndDescription oad) {

        m_Components.remove(oad);

    }

    /**
     * Adds a result to Arraylis
     * 
     * @param name
     *            the name of the object
     * @param object
     *            the object: JPanel, JTextArea, JTextPane, JLabel, JTable,
     *            HTMLPanel , PlotPanel and possibly any objects from Sextante
     */

    public static void addAdditionalResult(final String name,
            final Object object) {

        final ObjectAndDescription ob = new ObjectAndDescription(name, object);
        addComponent(ob);
    }

    /**
     * Adds the results to Arraylis
     * 
     * @param name
     *            the name of the object
     * @param objects
     *            An Array of Object: JPanel, JTextArea, JTextPane, JLabel,
     *            JTable, HTMLPanel , PlotPanel and possibly any objects from
     *            Sextante. Default syntax is "new Object(){panel1,panel2,...}"
     */

    public static void addAdditionalResults(final String name,
            final Object[] objects) {

        for (int i = 0; i < objects.length; i++) {
            final ObjectAndDescription ob = new ObjectAndDescription(name + "_"
                    + i, objects[i]);

            addComponent(ob);
        }
    }

    static WorkbenchFrame wFrame = JUMPWorkbench.getInstance().getFrame();

    /**
     * Adds a result to Arraylis and opens it into the AdditionalResultFrame
     * 
     * @param name
     *            the name of the object
     * @param object
     *            the object: JPanel, JTextArea, JTextPane, JLabel, JTable,
     *            HTMLPanel , PlotPanel and possibly any objects from Sextante
     * @param hideLeftPanel
     *            "true": left (list of object) panel is visible, "false": left
     *            (list of object) panel is not visible
     */
    public static void addAdditionalResultAndShow(final String name,
            final Object object, boolean hideLeftPanel) {

        final ObjectAndDescription ob = new ObjectAndDescription(name, object);
        addComponent(ob);
        for (final JInternalFrame iFrame : wFrame.getInternalFrames()) {
            if (iFrame instanceof AdditionalResultsFrame) {
                ((AdditionalResultsFrame) iFrame).update();
                iFrame.toFront();
                return;

            }
        }
        final AdditionalResultsFrame additionalResultsFrame = new AdditionalResultsFrame(
                m_Components);
        additionalResultsFrame.update();
        if (hideLeftPanel) {
            additionalResultsFrame.getLeftPanel().setVisible(true);
        }
        // additionalResults.setVisible(true);
        wFrame.addInternalFrame(additionalResultsFrame, true, true);
    }

    /**
     * Adds a result to Arraylis and opens it into the AdditionalResultFrame
     * Left panel (the list of object) is always visible
     * 
     * @param name
     *            the name of the object
     * @param object
     *            the object: JPanel, JTextArea, JTextPane, JLabel, JTable,
     *            HTMLPanel , PlotPanel and possibly any objects from Sextante
     */
    public static void addAdditionalResultAndShow(final String name,
            final Object object) {

        addAdditionalResultAndShow(name, object, true);

    }

    /**
     * Adds the results to Arraylis and opens it into the AdditionalResultFrame
     * Left panel (the list of object) is always visible
     * 
     * @param name
     *            the name of the object
     * @param objects
     *            An Array of Objects <JPanel, JTextArea, JTextPane, JLabel,
     *            JTable, HTMLPanel , PlotPanel and psibly any objects from
     *            JPanel, JTextArea, JTextPane, JLabel, JTable, HTMLPanel ,
     *            PlotPanel and possibly any objects from Sextante. Default
     *            syntax is "new Object(){panel1,panel2,...}"
     */
    public static void addAdditionalResultsAndShow(final String name,
            final Object[] objects) {

        for (int i = 0; i < objects.length; i++) {
            final ObjectAndDescription ob = new ObjectAndDescription(name + "_"
                    + i, objects[i]);

            addComponent(ob);
        }
        for (final JInternalFrame iFrame : wFrame.getInternalFrames()) {
            if (iFrame instanceof AdditionalResultsFrame) {
                ((AdditionalResultsFrame) iFrame).update();
                iFrame.toFront();

                return;

            }
        }
        final AdditionalResultsFrame additionalResultsFrame = new AdditionalResultsFrame(
                m_Components);

        // additionalResults.setVisible(true);
        wFrame.addInternalFrame(additionalResultsFrame, true, true);
    }

}
