/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.stream.input.spi.StringImageInputStreamSpi;
import it.geosolutions.imageio.stream.input.spi.URLImageInputStreamSpi;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdalconst.gdalconst;

public abstract class GDALImageReaderSpi
extends ImageReaderSpi {
    private static final Logger LOGGER = Logger.getLogger(GDALImageReaderSpi.class.toString());
    private static final StringImageInputStreamSpi stringSPI;
    private static final URLImageInputStreamSpi URLSPI;
    private List<String> supportedFormats;

    public List<String> getSupportedFormats() {
        return Collections.unmodifiableList(this.supportedFormats);
    }

    public GDALImageReaderSpi(String vendorName, String version, String[] names, String[] suffixes, String[] MIMETypes, String readerClassName, Class<?>[] inputTypes, String[] writerSpiNames, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames, Collection<String> supportedFormats) {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, inputTypes, writerSpiNames, supportsStandardStreamMetadataFormat, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, supportsStandardImageMetadataFormat, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        this.supportedFormats = new ArrayList<String>(supportedFormats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object input) throws IOException {
        if (input == null) {
            return false;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Can Decode Input called with object " + input != null ? input.toString() : "null");
        }
        File sourceFile = null;
        if (input instanceof String) {
            File file = new File((String)input);
            input = !file.exists() || !file.canRead() ? new URL((String)input) : file;
        }
        if (input instanceof URL) {
            input = ImageIOUtilities.urlToFile((URL)((URL)input));
        }
        if (input instanceof File) {
            sourceFile = (File)input;
        }
        if (input instanceof FileImageInputStreamExt) {
            sourceFile = ((FileImageInputStreamExt)input).getFile();
        }
        if (sourceFile == null || !sourceFile.exists() || !sourceFile.canRead()) {
            return false;
        }
        boolean isInputDecodable = false;
        Dataset ds = null;
        try {
            ds = GDALUtilities.acquireDataSet(sourceFile.getAbsolutePath(), gdalconst.GA_ReadOnly);
            isInputDecodable = this.isDecodable(ds);
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        finally {
            block21: {
                if (ds != null) {
                    try {
                        GDALUtilities.closeDataSet(ds);
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block21;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        return isInputDecodable;
    }

    protected boolean isDecodable(Dataset dataset) {
        if (dataset != null) {
            Driver driver = dataset.GetDriver();
            String sDriver = driver.getShortName();
            return this.getSupportedFormats().contains(sDriver);
        }
        return false;
    }

    public boolean isAvailable() {
        if (!GDALUtilities.isGDALAvailable()) {
            return false;
        }
        List<String> supportedFormats = this.getSupportedFormats();
        Iterator<String> it = supportedFormats.iterator();
        if (!it.hasNext()) {
            return false;
        }
        while (it.hasNext()) {
            String formatName = it.next();
            if (GDALUtilities.isDriverAvailable(formatName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onRegistration(ServiceRegistry registry, Class<?> category) {
        super.onRegistration(registry, category);
        if (!GDALUtilities.isGDALAvailable()) {
            IIORegistry iioRegistry = (IIORegistry)registry;
            Class<ImageReaderSpi> spiClass = ImageReaderSpi.class;
            Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
            while (iter.hasNext()) {
                ImageReaderSpi provider = iter.next();
                if (!(provider instanceof GDALImageReaderSpi)) continue;
                registry.deregisterServiceProvider(provider);
            }
        }
    }

    static {
        GDALUtilities.loadGDAL();
        stringSPI = new StringImageInputStreamSpi();
        URLSPI = new URLImageInputStreamSpi();
    }
}

