/*
 * Decompiled with CFR 0.152.
 */
package org.math.array.util;

import edu.cornell.lassp.houle.RngPack.RandomSeedable;
import edu.cornell.lassp.houle.RngPack.Ranmar;
import org.math.array.util.Function;

public class Random {
    public static RandomSeedable RandEngine = new Ranmar();

    public static double raw() {
        return RandEngine.raw();
    }

    public static int randInt(int i0, int i1) {
        double x = Random.raw();
        int i = i0 + new Double(Math.floor((double)(i1 - i0 + 1) * x)).intValue();
        return i;
    }

    public static double uniform(double min, double max) {
        double x = min + (max - min) * Random.raw();
        return x;
    }

    public static double dirac(double[] values, double[] prob) {
        double[] prob_cumul = new double[values.length];
        prob_cumul[0] = prob[0];
        for (int i = 1; i < values.length; ++i) {
            prob_cumul[i] = prob_cumul[i - 1] + prob[i];
        }
        double y = Random.raw();
        double x = 0.0;
        for (int i = 0; i < values.length - 1; ++i) {
            if (!(y > prob_cumul[i]) || !(y < prob_cumul[i + 1])) continue;
            x = values[i];
        }
        return x;
    }

    public static double normal(double mu, double sigma) {
        double x = mu + sigma * Math.cos(Math.PI * 2 * Random.raw()) * Math.sqrt(-2.0 * Math.log(Random.raw()));
        return x;
    }

    public static double chi2(int n) {
        double x = 0.0;
        for (int i = 0; i < n; ++i) {
            double norm = Random.normal(0.0, 1.0);
            x += norm * norm;
        }
        return x;
    }

    public static double logNormal(double mu, double sigma) {
        double x = mu + sigma * Math.cos(Math.PI * 2 * Random.raw()) * Math.sqrt(-2.0 * Math.log(Random.raw()));
        return Math.exp(x);
    }

    public static double exponential(double lambda) {
        double x = -1.0 / lambda * Math.log(Random.raw());
        return x;
    }

    public static double triangular(double min, double max) {
        double x = min / 2.0 + (max - min) * Random.raw() / 2.0 + min / 2.0 + (max - min) * Random.raw() / 2.0;
        return x;
    }

    public static double triangular(double min, double med, double max) {
        double y = Random.raw();
        double x = y < (med - min) / (max - min) ? min + Math.sqrt(y * (max - min) * (med - min)) : max - Math.sqrt((1.0 - y) * (max - min) * (max - med));
        return x;
    }

    public static double beta(double a, double b) {
        double try_y;
        double try_x;
        while ((try_x = Math.pow(Random.raw(), 1.0 / a)) + (try_y = Math.pow(Random.raw(), 1.0 / b)) > 1.0) {
        }
        return try_x / (try_x + try_y);
    }

    public static double cauchy(double mu, double sigma) {
        double x = sigma * Math.tan(Math.PI * (Random.raw() - 0.5)) + mu;
        return x;
    }

    public static double weibull(double lambda, double c) {
        double x = Math.pow(-Math.log(1.0 - Random.raw()), 1.0 / c) / lambda;
        return x;
    }

    public static double rejection(Function fun, double maxFun, double min, double max) {
        double try_y;
        double try_x;
        do {
            try_x = min + Random.raw() * (max - min);
            try_y = Random.raw() * maxFun;
        } while (fun.f(try_x) < try_y);
        return try_x;
    }
}

