/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.ogr;

import java.util.Vector;
import org.gdal.gdal.MajorObject;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.GeomFieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.ProgressCallback;
import org.gdal.ogr.StyleTable;
import org.gdal.ogr.ogrJNI;
import org.gdal.osr.SpatialReference;

public class Layer
extends MajorObject {
    private long swigCPtr;
    private Object parentReference;

    public Layer(long cPtr, boolean cMemoryOwn) {
        super(ogrJNI.Layer_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(Layer obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static long getCPtrAndDisown(Layer obj) {
        if (obj != null) {
            obj.swigCMemOwn = false;
            obj.parentReference = null;
        }
        return Layer.getCPtr(obj);
    }

    @Override
    public void addReference(Object reference) {
        this.parentReference = reference;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Layer) {
            equal = ((Layer)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public double[] GetExtent(boolean force) {
        double[] argout = new double[4];
        try {
            int ret = this.GetExtent(argout, force ? 1 : 0);
            return (double[])(ret == 0 ? argout : null);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public double[] GetExtent() {
        return this.GetExtent(true);
    }

    public int Rename(String new_name) {
        return ogrJNI.Layer_Rename(this.swigCPtr, this, new_name);
    }

    public int GetRefCount() {
        return ogrJNI.Layer_GetRefCount(this.swigCPtr, this);
    }

    public void SetSpatialFilter(Geometry filter) {
        ogrJNI.Layer_SetSpatialFilter__SWIG_0(this.swigCPtr, this, Geometry.getCPtr(filter), filter);
    }

    public void SetSpatialFilterRect(double minx, double miny, double maxx, double maxy) {
        ogrJNI.Layer_SetSpatialFilterRect__SWIG_0(this.swigCPtr, this, minx, miny, maxx, maxy);
    }

    public void SetSpatialFilter(int iGeomField, Geometry filter) {
        ogrJNI.Layer_SetSpatialFilter__SWIG_1(this.swigCPtr, this, iGeomField, Geometry.getCPtr(filter), filter);
    }

    public void SetSpatialFilterRect(int iGeomField, double minx, double miny, double maxx, double maxy) {
        ogrJNI.Layer_SetSpatialFilterRect__SWIG_1(this.swigCPtr, this, iGeomField, minx, miny, maxx, maxy);
    }

    public Geometry GetSpatialFilter() {
        long cPtr = ogrJNI.Layer_GetSpatialFilter(this.swigCPtr, this);
        Geometry ret = null;
        if (cPtr != 0L) {
            ret = new Geometry(cPtr, false);
            ret.addReference(this);
        }
        return ret;
    }

    public int SetAttributeFilter(String filter_string) {
        return ogrJNI.Layer_SetAttributeFilter(this.swigCPtr, this, filter_string);
    }

    public void ResetReading() {
        ogrJNI.Layer_ResetReading(this.swigCPtr, this);
    }

    public String GetName() {
        return ogrJNI.Layer_GetName(this.swigCPtr, this);
    }

    public int GetGeomType() {
        return ogrJNI.Layer_GetGeomType(this.swigCPtr, this);
    }

    public String GetGeometryColumn() {
        return ogrJNI.Layer_GetGeometryColumn(this.swigCPtr, this);
    }

    public String GetFIDColumn() {
        return ogrJNI.Layer_GetFIDColumn(this.swigCPtr, this);
    }

    public Feature GetFeature(long fid) {
        long cPtr = ogrJNI.Layer_GetFeature(this.swigCPtr, this, fid);
        return cPtr == 0L ? null : new Feature(cPtr, true);
    }

    public Feature GetNextFeature() {
        long cPtr = ogrJNI.Layer_GetNextFeature(this.swigCPtr, this);
        return cPtr == 0L ? null : new Feature(cPtr, true);
    }

    public int SetNextByIndex(long new_index) {
        return ogrJNI.Layer_SetNextByIndex(this.swigCPtr, this, new_index);
    }

    public int SetFeature(Feature feature) {
        return ogrJNI.Layer_SetFeature(this.swigCPtr, this, Feature.getCPtr(feature), feature);
    }

    public int CreateFeature(Feature feature) {
        return ogrJNI.Layer_CreateFeature(this.swigCPtr, this, Feature.getCPtr(feature), feature);
    }

    public int UpsertFeature(Feature feature) {
        return ogrJNI.Layer_UpsertFeature(this.swigCPtr, this, Feature.getCPtr(feature), feature);
    }

    public int UpdateFeature(Feature feature, int[] nUpdatedFieldsCount, int[] nUpdatedGeomFieldsCount, boolean bUpdateStyleString) {
        return ogrJNI.Layer_UpdateFeature(this.swigCPtr, this, Feature.getCPtr(feature), feature, nUpdatedFieldsCount, nUpdatedGeomFieldsCount, bUpdateStyleString);
    }

    public int DeleteFeature(long fid) {
        return ogrJNI.Layer_DeleteFeature(this.swigCPtr, this, fid);
    }

    public int SyncToDisk() {
        return ogrJNI.Layer_SyncToDisk(this.swigCPtr, this);
    }

    public FeatureDefn GetLayerDefn() {
        long cPtr = ogrJNI.Layer_GetLayerDefn(this.swigCPtr, this);
        FeatureDefn ret = null;
        if (cPtr != 0L) {
            ret = new FeatureDefn(cPtr, true);
            ret.addReference(this);
        }
        return ret;
    }

    public long GetFeatureCount(int force) {
        return ogrJNI.Layer_GetFeatureCount__SWIG_0(this.swigCPtr, this, force);
    }

    public long GetFeatureCount() {
        return ogrJNI.Layer_GetFeatureCount__SWIG_1(this.swigCPtr, this);
    }

    public int GetExtent(double[] argout, int force) {
        return ogrJNI.Layer_GetExtent(this.swigCPtr, this, argout, force);
    }

    public boolean TestCapability(String cap) {
        return ogrJNI.Layer_TestCapability(this.swigCPtr, this, cap);
    }

    public int CreateField(FieldDefn field_def, int approx_ok) {
        return ogrJNI.Layer_CreateField__SWIG_0(this.swigCPtr, this, FieldDefn.getCPtr(field_def), field_def, approx_ok);
    }

    public int CreateField(FieldDefn field_def) {
        return ogrJNI.Layer_CreateField__SWIG_1(this.swigCPtr, this, FieldDefn.getCPtr(field_def), field_def);
    }

    public int DeleteField(int iField) {
        return ogrJNI.Layer_DeleteField(this.swigCPtr, this, iField);
    }

    public int ReorderField(int iOldFieldPos, int iNewFieldPos) {
        return ogrJNI.Layer_ReorderField(this.swigCPtr, this, iOldFieldPos, iNewFieldPos);
    }

    public int ReorderFields(int[] nList) {
        return ogrJNI.Layer_ReorderFields(this.swigCPtr, this, nList);
    }

    public int AlterFieldDefn(int iField, FieldDefn field_def, int nFlags) {
        return ogrJNI.Layer_AlterFieldDefn(this.swigCPtr, this, iField, FieldDefn.getCPtr(field_def), field_def, nFlags);
    }

    public int AlterGeomFieldDefn(int iGeomField, GeomFieldDefn field_def, int nFlags) {
        return ogrJNI.Layer_AlterGeomFieldDefn(this.swigCPtr, this, iGeomField, GeomFieldDefn.getCPtr(field_def), field_def, nFlags);
    }

    public int CreateGeomField(GeomFieldDefn field_def, int approx_ok) {
        return ogrJNI.Layer_CreateGeomField__SWIG_0(this.swigCPtr, this, GeomFieldDefn.getCPtr(field_def), field_def, approx_ok);
    }

    public int CreateGeomField(GeomFieldDefn field_def) {
        return ogrJNI.Layer_CreateGeomField__SWIG_1(this.swigCPtr, this, GeomFieldDefn.getCPtr(field_def), field_def);
    }

    public int StartTransaction() {
        return ogrJNI.Layer_StartTransaction(this.swigCPtr, this);
    }

    public int CommitTransaction() {
        return ogrJNI.Layer_CommitTransaction(this.swigCPtr, this);
    }

    public int RollbackTransaction() {
        return ogrJNI.Layer_RollbackTransaction(this.swigCPtr, this);
    }

    public int FindFieldIndex(String pszFieldName, int bExactMatch) {
        return ogrJNI.Layer_FindFieldIndex(this.swigCPtr, this, pszFieldName, bExactMatch);
    }

    public SpatialReference GetSpatialRef() {
        long cPtr = ogrJNI.Layer_GetSpatialRef(this.swigCPtr, this);
        return cPtr == 0L ? null : new SpatialReference(cPtr, true);
    }

    public long GetFeaturesRead() {
        return ogrJNI.Layer_GetFeaturesRead(this.swigCPtr, this);
    }

    public int SetIgnoredFields(Vector options) {
        return ogrJNI.Layer_SetIgnoredFields(this.swigCPtr, this, options);
    }

    public int Intersection(Layer method_layer, Layer result_layer, Vector options, ProgressCallback callback) {
        return ogrJNI.Layer_Intersection__SWIG_0(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options, callback);
    }

    public int Intersection(Layer method_layer, Layer result_layer, Vector options) {
        return ogrJNI.Layer_Intersection__SWIG_2(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options);
    }

    public int Intersection(Layer method_layer, Layer result_layer) {
        return ogrJNI.Layer_Intersection__SWIG_3(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer);
    }

    public int Union(Layer method_layer, Layer result_layer, Vector options, ProgressCallback callback) {
        return ogrJNI.Layer_Union__SWIG_0(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options, callback);
    }

    public int Union(Layer method_layer, Layer result_layer, Vector options) {
        return ogrJNI.Layer_Union__SWIG_2(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options);
    }

    public int Union(Layer method_layer, Layer result_layer) {
        return ogrJNI.Layer_Union__SWIG_3(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer);
    }

    public int SymDifference(Layer method_layer, Layer result_layer, Vector options, ProgressCallback callback) {
        return ogrJNI.Layer_SymDifference__SWIG_0(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options, callback);
    }

    public int SymDifference(Layer method_layer, Layer result_layer, Vector options) {
        return ogrJNI.Layer_SymDifference__SWIG_2(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options);
    }

    public int SymDifference(Layer method_layer, Layer result_layer) {
        return ogrJNI.Layer_SymDifference__SWIG_3(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer);
    }

    public int Identity(Layer method_layer, Layer result_layer, Vector options, ProgressCallback callback) {
        return ogrJNI.Layer_Identity__SWIG_0(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options, callback);
    }

    public int Identity(Layer method_layer, Layer result_layer, Vector options) {
        return ogrJNI.Layer_Identity__SWIG_2(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options);
    }

    public int Identity(Layer method_layer, Layer result_layer) {
        return ogrJNI.Layer_Identity__SWIG_3(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer);
    }

    public int Update(Layer method_layer, Layer result_layer, Vector options, ProgressCallback callback) {
        return ogrJNI.Layer_Update__SWIG_0(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options, callback);
    }

    public int Update(Layer method_layer, Layer result_layer, Vector options) {
        return ogrJNI.Layer_Update__SWIG_2(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options);
    }

    public int Update(Layer method_layer, Layer result_layer) {
        return ogrJNI.Layer_Update__SWIG_3(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer);
    }

    public int Clip(Layer method_layer, Layer result_layer, Vector options, ProgressCallback callback) {
        return ogrJNI.Layer_Clip__SWIG_0(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options, callback);
    }

    public int Clip(Layer method_layer, Layer result_layer, Vector options) {
        return ogrJNI.Layer_Clip__SWIG_2(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options);
    }

    public int Clip(Layer method_layer, Layer result_layer) {
        return ogrJNI.Layer_Clip__SWIG_3(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer);
    }

    public int Erase(Layer method_layer, Layer result_layer, Vector options, ProgressCallback callback) {
        return ogrJNI.Layer_Erase__SWIG_0(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options, callback);
    }

    public int Erase(Layer method_layer, Layer result_layer, Vector options) {
        return ogrJNI.Layer_Erase__SWIG_2(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer, options);
    }

    public int Erase(Layer method_layer, Layer result_layer) {
        return ogrJNI.Layer_Erase__SWIG_3(this.swigCPtr, this, Layer.getCPtr(method_layer), method_layer, Layer.getCPtr(result_layer), result_layer);
    }

    public StyleTable GetStyleTable() {
        long cPtr = ogrJNI.Layer_GetStyleTable(this.swigCPtr, this);
        return cPtr == 0L ? null : new StyleTable(cPtr, false);
    }

    public void SetStyleTable(StyleTable table) {
        ogrJNI.Layer_SetStyleTable(this.swigCPtr, this, StyleTable.getCPtr(table), table);
    }

    public int SetActiveSRS(int geom_field, SpatialReference srs) {
        return ogrJNI.Layer_SetActiveSRS(this.swigCPtr, this, geom_field, SpatialReference.getCPtr(srs), srs);
    }
}

