/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot3DPanel;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class BoxPlot3D
extends Plot {
    double[] Xmin;
    double[] Xmax;
    double[] Ymin;
    double[] Ymax;
    double[] Zmin;
    double[] Zmax;
    double[][] widths;
    double[][] XY;

    public BoxPlot3D(double[][] _XY, double[][] w, Color c, String n) {
        super(n, c);
        this.XY = _XY;
        this.widths = w;
        this.Xmin = new double[this.XY.length];
        this.Xmax = new double[this.XY.length];
        this.Ymin = new double[this.XY.length];
        this.Ymax = new double[this.XY.length];
        this.Zmin = new double[this.XY.length];
        this.Zmax = new double[this.XY.length];
        for (int i = 0; i < this.XY.length; ++i) {
            this.Xmin[i] = this.XY[i][0] - this.widths[i][0] / 2.0;
            this.Xmax[i] = this.XY[i][0] + this.widths[i][0] / 2.0;
            this.Ymin[i] = this.XY[i][1] - this.widths[i][1] / 2.0;
            this.Ymax[i] = this.XY[i][1] + this.widths[i][1] / 2.0;
            this.Zmin[i] = this.XY[i][2] - this.widths[i][2] / 2.0;
            this.Zmax[i] = this.XY[i][2] + this.widths[i][2] / 2.0;
        }
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.visible) {
            return;
        }
        draw.setColor(c);
        draw.setLineType(1);
        for (int i = 0; i < this.XY.length; ++i) {
            draw.drawLine({this.Xmin[i], this.Ymin[i], this.Zmin[i]}, {this.Xmax[i], this.Ymin[i], this.Zmin[i]});
            draw.drawLine({this.Xmax[i], this.Ymin[i], this.Zmin[i]}, {this.Xmax[i], this.Ymax[i], this.Zmin[i]});
            draw.drawLine({this.Xmax[i], this.Ymax[i], this.Zmin[i]}, {this.Xmin[i], this.Ymax[i], this.Zmin[i]});
            draw.drawLine({this.Xmin[i], this.Ymax[i], this.Zmin[i]}, {this.Xmin[i], this.Ymin[i], this.Zmin[i]});
            draw.drawLine({this.Xmin[i], this.Ymin[i], this.Zmax[i]}, {this.Xmax[i], this.Ymin[i], this.Zmax[i]});
            draw.drawLine({this.Xmax[i], this.Ymin[i], this.Zmax[i]}, {this.Xmax[i], this.Ymax[i], this.Zmax[i]});
            draw.drawLine({this.Xmax[i], this.Ymax[i], this.Zmax[i]}, {this.Xmin[i], this.Ymax[i], this.Zmax[i]});
            draw.drawLine({this.Xmin[i], this.Ymax[i], this.Zmax[i]}, {this.Xmin[i], this.Ymin[i], this.Zmax[i]});
            draw.drawLine({this.Xmin[i], this.Ymin[i], this.Zmin[i]}, {this.Xmin[i], this.Ymin[i], this.Zmax[i]});
            draw.drawLine({this.Xmax[i], this.Ymin[i], this.Zmin[i]}, {this.Xmax[i], this.Ymin[i], this.Zmax[i]});
            draw.drawLine({this.Xmin[i], this.Ymax[i], this.Zmin[i]}, {this.Xmin[i], this.Ymax[i], this.Zmax[i]});
            draw.drawLine({this.Xmax[i], this.Ymax[i], this.Zmin[i]}, {this.Xmax[i], this.Ymax[i], this.Zmax[i]});
            draw.drawDot(this.XY[i]);
        }
    }

    @Override
    public void setData(double[][] d) {
        this.datapanel = null;
        this.XY = d;
    }

    @Override
    public double[][] getData() {
        return this.XY;
    }

    @Override
    public double[][] getBounds() {
        return new double[][]{{Array.min(this.Xmin), Array.min(this.Ymin), Array.min(this.Zmin)}, {Array.max(this.Xmax), Array.max(this.Ymax), Array.max(this.Zmax)}};
    }

    public void setDataWidth(double[][] w) {
        this.widths = w;
    }

    public double[][] getDataWidth() {
        return this.widths;
    }

    public void setData(double[][] d, double[][] w) {
        this.setData(d);
        this.widths = w;
    }

    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        for (int i = 0; i < this.XY.length; ++i) {
            int[] screenCoord = draw.project(this.XY[i]);
            if (screenCoord[0] + this.note_precision <= screenCoordTest[0] || screenCoord[0] - this.note_precision >= screenCoordTest[0] || screenCoord[1] + this.note_precision <= screenCoordTest[1] || screenCoord[1] - this.note_precision >= screenCoordTest[1]) continue;
            return this.XY[i];
        }
        return null;
    }

    public static void main(String[] args) {
        Plot3DPanel plotpanel = new Plot3DPanel();
        for (int i = 0; i < 1; ++i) {
            double[][] receiverXYZ = new double[100][6];
            for (int j = 0; j < receiverXYZ.length; ++j) {
                receiverXYZ[j][0] = Math.random();
                receiverXYZ[j][1] = Math.random();
                receiverXYZ[j][2] = Math.random();
                receiverXYZ[j][3] = Math.random() / 10.0;
                receiverXYZ[j][4] = Math.random() / 10.0;
                receiverXYZ[j][5] = Math.random() / 10.0;
            }
            int n = plotpanel.addBoxPlot("Receivers", Color.orange, receiverXYZ);
        }
        plotpanel.setLegendOrientation("South");
        new FrameView(plotpanel).setDefaultCloseOperation(3);
    }
}

