package org.openjump.core.rasterimage.styler.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.swing.JOptionPane;

import org.openjump.core.attributeoperations.Classifier1D;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.ColorUtils;
import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.RasterClassifier1D;
import org.openjump.core.rasterimage.styler.RasterStylesExtension;
import org.openjump.core.rasterimage.styler.Utils;
import org.openjump.core.rasterimage.styler.ui.ColorsTablePanel.TableType;

import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.workbench.Logger;

/**
 *
 * @author GeomaticaEAmbiente
 */
public class IntervalPanel extends javax.swing.JPanel {

    /**
     * Creates new form IntervalPanel
     * @param parent parent Component
     * @param rasterImageLayer rasterImageLayer to symbolize
     * @param minMaxValues min and max pixel values for this image
     */
    public IntervalPanel(Component parent, RasterImageLayer rasterImageLayer, Range minMaxValues) {

        initComponents();
        this.parent = parent;
        this.rasterImageLayer = rasterImageLayer;
        this.minMaxValues = minMaxValues;
        
        fixComponents();
    }

    public void reset() {
        try {
            jComboBox_Method.setSelectedItem(classMethods_m.get(ClassificationMethod.JENKS));
            jTextField_Classes.setText("5");
            jComboBox_Gradient.setSelectedIndex(0);
            rampAll();
        } catch (Exception ex) {
            Logger.error(ex);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel_Method = new javax.swing.JLabel();
        jComboBox_Method = new javax.swing.JComboBox();
        jButton_Values = new javax.swing.JButton();
        jLabel_Classes = new javax.swing.JLabel();
        jTextField_Classes = new javax.swing.JTextField();
        jPanel_Table = new javax.swing.JPanel();
        jButton_AddRow = new javax.swing.JButton();
        jButton_RemoveRow = new javax.swing.JButton();
        jButton_Ramp = new javax.swing.JButton();

        setMinimumSize(new java.awt.Dimension(365, 160));
        setPreferredSize(new java.awt.Dimension(365, 160));
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        java.awt.GridBagLayout layout = new java.awt.GridBagLayout();
        layout.columnWidths = new int[] {0, 5, 0, 5, 0};
        layout.rowHeights = new int[] {0, 5, 0, 5, 0, 5, 0, 5, 0};
        setLayout(layout);

        jLabel_Method.setText(I18N.get("IntervalPanel.jLabel.method")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        add(jLabel_Method, gridBagConstraints);

        jComboBox_Method.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_Method.addActionListener(this::jComboBox_MethodActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 3;
        add(jComboBox_Method, gridBagConstraints);

        jButton_Values.setText(I18N.get("IntervalPanel.jButton.RampAll")); // NOI18N
        jButton_Values.addActionListener(this::jButton_ValuesActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jButton_Values, gridBagConstraints);

        jLabel_Classes.setText(I18N.get("IntervalPanel.jLabel.Classes")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        add(jLabel_Classes, gridBagConstraints);

        jTextField_Classes.setText("5");
        jTextField_Classes.setMinimumSize(new java.awt.Dimension(70, 20));
        jTextField_Classes.setPreferredSize(new java.awt.Dimension(70, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(jTextField_Classes, gridBagConstraints);

        jPanel_Table.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel_Table.setName(""); // NOI18N
        jPanel_Table.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.5;
        add(jPanel_Table, gridBagConstraints);

        jButton_AddRow.setText(I18N.get("IntervalPanel.jButton.AddRow")); // NOI18N
        jButton_AddRow.addActionListener(this::jButton_AddRowActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        add(jButton_AddRow, gridBagConstraints);

        jButton_RemoveRow.setText(I18N.get("IntervalPanel.jButton.RemoveRow")); // NOI18N
        jButton_RemoveRow.addActionListener(this::jButton_RemoveRowActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        add(jButton_RemoveRow, gridBagConstraints);

        jButton_Ramp.setText(I18N.get("IntervalPanel.jButton.Ramp")); // NOI18N
        jButton_Ramp.addActionListener(this::jButton_RampActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jButton_Ramp, gridBagConstraints);
    }

    private void jButton_ValuesActionPerformed(java.awt.event.ActionEvent evt) {
        try {
            rampAll();
        } catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void jButton_AddRowActionPerformed(java.awt.event.ActionEvent evt) {
        addRow();
    }

    private void jButton_RemoveRowActionPerformed(java.awt.event.ActionEvent evt) {
        removeRow();
    }

    private void jButton_RampActionPerformed(java.awt.event.ActionEvent evt) {
        try {
            rampColors();
        } catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void jComboBox_MethodActionPerformed(java.awt.event.ActionEvent evt) {
        // TODO add your handling code here:
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {
        
        if(firstTimeShown) {
            firstTimeShown = false;
            try {
                rampAll();
            } catch (Exception ex) {
                Logger.error(ex);
            }
        }
        
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton_AddRow;
    private javax.swing.JButton jButton_Ramp;
    private javax.swing.JButton jButton_RemoveRow;
    private javax.swing.JButton jButton_Values;
    private javax.swing.JComboBox jComboBox_Method;
    private javax.swing.JLabel jLabel_Classes;
    private javax.swing.JLabel jLabel_Method;
    private javax.swing.JPanel jPanel_Table;
    private javax.swing.JTextField jTextField_Classes;
    // End of variables declaration//GEN-END:variables

    private void fixComponents() {
        
        classMethods_m.put(ClassificationMethod.EQUAL_RANGE, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.EqualInterval"));
        classMethods_m.put(ClassificationMethod.GIVEN_INTERVAL, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.GivenInterval"));
        classMethods_m.put(ClassificationMethod.JENKS, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.Jenks"));
        classMethods_m.put(ClassificationMethod.MAX_BREAKS, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.MaxBreaks"));
        classMethods_m.put(ClassificationMethod.MEAN_STDEV, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.MeanStDev"));
        classMethods_m.put(ClassificationMethod.QUANTILE, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.Quantiles"));
        
        jComboBox_Method.removeAllItems();
        jComboBox_Method.addItem(classMethods_m.get(ClassificationMethod.EQUAL_RANGE));
        jComboBox_Method.addItem(classMethods_m.get(ClassificationMethod.GIVEN_INTERVAL));
        jComboBox_Method.addItem(classMethods_m.get(ClassificationMethod.JENKS));
        jComboBox_Method.addItem(classMethods_m.get(ClassificationMethod.MAX_BREAKS));
        jComboBox_Method.addItem(classMethods_m.get(ClassificationMethod.MEAN_STDEV));
        jComboBox_Method.addItem(classMethods_m.get(ClassificationMethod.QUANTILE));
        jComboBox_Method.setSelectedItem(classMethods_m.get(ClassificationMethod.JENKS));

        // Listener
        jComboBox_Method.addActionListener (new ActionListener () {
            @Override
            public void actionPerformed(ActionEvent e) {
                
                ClassificationMethod classMethod = getKeyByValue(classMethods_m, jComboBox_Method.getSelectedItem().toString());
                if(classMethod == ClassificationMethod.GIVEN_INTERVAL) {
                    jLabel_Classes.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.jLabel.classwidth"));
                } else {
                    jLabel_Classes.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.jLabel.Classes"));
                }
                
            }
        });
        
        // Color ramps       
        jComboBox_Gradient = GUIUtils.createStandardGradientComboBox(200, 18);

        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jComboBox_Gradient, gridBagConstraints);
        
        GUIUtils.addGradientComboBoxToList(jComboBox_Gradient);
        
    }
    
    private void rampAll() throws Exception {
        
        int classesCount = 5;
        try {
            classesCount = Integer.parseInt(jTextField_Classes.getText());
        } catch(Exception ex) {
                JOptionPane.showMessageDialog(
                this,
                I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.numberOfClassesError"),
                RasterStylesExtension.extensionName,
                JOptionPane.WARNING_MESSAGE);
            return;
        }
        double classWidth = 0;
        
        double[] breaks = null;
        double[] rasterData = Utils.purgeNoData(rasterImageLayer.getActualRasterData(),rasterImageLayer);
        
        ClassificationMethod classMethod = getKeyByValue(classMethods_m, jComboBox_Method.getSelectedItem().toString());
        switch (classMethod) {
            
            case EQUAL_RANGE:
                breaks = Classifier1D.classifyEqualRange(rasterData, classesCount);
                break;
            case GIVEN_INTERVAL:
                breaks = RasterClassifier1D.classifyGivenInterval(rasterImageLayer, 0, classesCount);
                classWidth = classesCount;
                classesCount = breaks.length;
                break;
            case JENKS:
                /* Sampling needed */
                int top = 1000;
                if(rasterData.length > top) {
                    List<Double> sampled_l = new ArrayList<Double>();
                    sampled_l.add((Double) minMaxValues.getMin());
                    sampled_l.add((Double) minMaxValues.getMax());
                    for(int v=0; v<rasterData.length; v=v+(rasterData.length / top)) {
                        sampled_l.add(rasterData[v]);
                    }
                    double[] sampledRasterData = new double[sampled_l.size()];
                    for(int v=0; v<sampled_l.size(); v++) {
                        sampledRasterData[v] = sampled_l.get(v);
                    }
                    breaks = Classifier1D.classifyNaturalBreaks(sampledRasterData, classesCount);
                    break;
                }
                
                breaks = Classifier1D.classifyNaturalBreaks(rasterData, classesCount);
                break;
            case MAX_BREAKS:
                breaks = Classifier1D.classifyMaxBreaks(rasterData, classesCount);
                break;
            case MEAN_STDEV:
                breaks = Classifier1D.classifyMeanStandardDeviation(rasterData, classesCount);
                break;
            case QUANTILE:
                breaks = Classifier1D.classifyEqualNumber(rasterData, classesCount);
                break;
        }

        if(breaks == null) {
            throw new Exception(I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.message.ErrorWhileClassifying"));
        }

        ColorMapEntry[] paletteColorMapEntries = ((GradientCanvas) jComboBox_Gradient.getSelectedItem()).getColorMapEntries();
        
        /* Calculate colors */
        ColorUtils colorUtils = new ColorUtils();
        ColorMapEntry[] colorMapEntries = new ColorMapEntry[classesCount];
        int colorsCount = paletteColorMapEntries.length;
        
        double minVal = (Double) minMaxValues.getMin();
        if(classMethod == ClassificationMethod.GIVEN_INTERVAL) {
            minVal = Math.floor((Double) minMaxValues.getMin() / classWidth) * classWidth;
        }
        
        colorMapEntries[0] = new ColorMapEntry(minVal, paletteColorMapEntries[0].getColor());
        for(int c=1; c<classesCount; c++) {
            
            double cellRelDistance = (double) c / (double) (classesCount-1);
            double colorRelDistance = cellRelDistance * (colorsCount - 1);
            
            Color startColor = paletteColorMapEntries[(int) Math.floor(colorRelDistance)].getColor();
            Color endColor = paletteColorMapEntries[(int) Math.ceil(colorRelDistance)].getColor();
            
            Color color = colorUtils.interpolateColor(startColor, endColor, cellRelDistance);
            colorMapEntries[c] = new ColorMapEntry(breaks[c-1], color);
        }
        
        updateTable(colorMapEntries);
        
    }
    
    private void addRow() {
        colorsTablePanel.addRows();
    }
    
    private void removeRow() {
        colorsTablePanel.removeRow();
    }
    
    private void rampColors() throws Exception {
        if(colorsTablePanel.getSelectedRowsCount() != 2) {
            JOptionPane.showMessageDialog(
                    this,
                    I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.EqualInterval.SelectTowRowsToRamp"),
                    RasterStylesExtension.extensionName,
                    JOptionPane.WARNING_MESSAGE);
        }
        colorsTablePanel.rampColors();
    }
    
    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Entry<T, E> entry : map.entrySet()) {
            if (value.equals(entry.getValue())) {
                return entry.getKey();
            }
        }
        return null;
    }
    
    public void plugRasterSymbology(RasterSymbology rasterSymbology) {
        
        updateTable(rasterSymbology.getColorMapEntries());
        
    }
    
    private void updateTable(ColorMapEntry[] colorMapEntries) {
        
        /* Update table */
        if(colorsTablePanel == null) {
            colorsTablePanel = new ColorsTablePanel(parent, TableType.INTERVALS,
                    colorMapEntries, rasterImageLayer.getNoDataValue(), false);
            GridBagLayout layout = (GridBagLayout)getLayout();
            GridBagConstraints gbc = layout.getConstraints(jPanel_Table);
            remove(jPanel_Table);
            add(colorsTablePanel, gbc, 5);
            validate();
        } else {
            colorsTablePanel.updateTable(colorMapEntries);
        }
        
    }
    
    public RasterSymbology getRasterStyler() throws Exception{
        
        RasterSymbology rasterSymbolizer = new RasterSymbology(RasterSymbology.TYPE_INTERVALS);
        for (ColorMapEntry colorMapEntry : colorsTablePanel.getColorMapEntries()) {
            rasterSymbolizer.addColorMapEntry(colorMapEntry.getUpperValue(), colorMapEntry.getColor());
        }
        
        return rasterSymbolizer;
    }
 
    private final Component parent;
    private final Map<ClassificationMethod,String> classMethods_m = new EnumMap<ClassificationMethod,String>(ClassificationMethod.class);
    private RasterImageLayer rasterImageLayer = null;
    private ColorsTablePanel colorsTablePanel = null;
    private final Range minMaxValues;
    private GradientComboBox jComboBox_Gradient;
    private boolean firstTimeShown = true;
    
    public enum ClassificationMethod {
        
            UNIQUE_VALUE, EQUAL_RANGE, GIVEN_INTERVAL, QUANTILE, MEAN_STDEV, MAX_BREAKS, JENKS;
    
    }

    public GradientComboBox getjComboBox_Gradient() {
        return jComboBox_Gradient;
    }
}

