package org.openjump.core.rasterimage.styler.ui;

import javax.swing.JOptionPane;

import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.RasterStylesExtension;

/**
 * Dialog to set the raster noData value.
 * It is used only if getNoDataValue() in RasterImageLayer doesn't exist (in old
 * OpenJUMP versions).
 * @author GeomaticaEAmbiente
 */
public class NoDataValueDialog extends javax.swing.JDialog {

    /**
     * Creates new form NoDataValueDialog
     * @param parent parent Frame
     * @param modal whether the Dialog is modal or not
     */
    public NoDataValueDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        fixComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel_Message = new javax.swing.JLabel();
        jTextField_NoDataValue = new javax.swing.JTextField();
        jButton_Cancel = new javax.swing.JButton();
        jButton_Memorize = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setMinimumSize(new java.awt.Dimension(250, 170));
        setPreferredSize(new java.awt.Dimension(250, 170));
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jLabel_Message.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.NoDataValueDialog.jLabel_Message.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 20, 0);
        getContentPane().add(jLabel_Message, gridBagConstraints);

        jTextField_NoDataValue.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.NoDataValueDialog.jTextField_NoDataValue.text")); // NOI18N
        jTextField_NoDataValue.setMinimumSize(new java.awt.Dimension(110, 20));
        jTextField_NoDataValue.setPreferredSize(new java.awt.Dimension(110, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.ipadx = 53;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 20, 0);
        getContentPane().add(jTextField_NoDataValue, gridBagConstraints);

        jButton_Cancel.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.NoDataValueDialog.jButton_Cancel.text")); // NOI18N
        jButton_Cancel.setMaximumSize(new java.awt.Dimension(77, 23));
        jButton_Cancel.setMinimumSize(new java.awt.Dimension(77, 23));
        jButton_Cancel.setPreferredSize(new java.awt.Dimension(77, 23));
        jButton_Cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        getContentPane().add(jButton_Cancel, gridBagConstraints);

        jButton_Memorize.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.NoDataValueDialog.jButton_Memorize.text")); // NOI18N
        jButton_Memorize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_MemorizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        getContentPane().add(jButton_Memorize, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton_MemorizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_MemorizeActionPerformed
        
        //Check value
        try{
            double value = Double.parseDouble(jTextField_NoDataValue.getText());
        
        } catch(NumberFormatException nfe){
            JOptionPane.showMessageDialog(this, I18N.get("org.openjump.core.rasterimage.styler.ui.NoDataValueDialog.Values.message"), RasterStylesExtension.extensionName, WIDTH);
        }
        
        noDataValue = Double.parseDouble(jTextField_NoDataValue.getText());
        dispose();
        
        
    }//GEN-LAST:event_jButton_MemorizeActionPerformed

    private void jButton_CancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_CancelActionPerformed

        dispose();
        
    }//GEN-LAST:event_jButton_CancelActionPerformed

    private void fixComponents(){
        this.setTitle(RasterStylesExtension.extensionName);
    }   
    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton_Cancel;
    private javax.swing.JButton jButton_Memorize;
    private javax.swing.JLabel jLabel_Message;
    private javax.swing.JTextField jTextField_NoDataValue;
    // End of variables declaration//GEN-END:variables
    private Double noDataValue = null;

    
    public Double getNoDataValue() {
        return noDataValue;
    }   

}
