/*
 * Decompiled with CFR 0.152.
 */
package org.math.io.parser;

public class ArrayString {
    public static String defaultColumnDelimiter = " ";
    public static String defaultRowDelimiter = "\n";
    public static String NotFoundDelimiter = "ZYXWV";

    public static String printDoubleArray(double[] m) {
        return ArrayString.printDoubleArray(new double[][]{m});
    }

    public static String printDoubleArray(double[][] m) {
        return ArrayString.printDoubleArray(m, defaultColumnDelimiter, defaultRowDelimiter);
    }

    public static String printDoubleArray(double[][] m, String wordDelimiter, String sentenceDelimiter) {
        StringBuffer str = new StringBuffer(25 * m.length * m[0].length);
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length - 1; ++j) {
                str = str.append(Double.toString(m[i][j]));
                str = str.append(wordDelimiter);
            }
            str = str.append(Double.toString(m[i][m[i].length - 1]));
            if (i >= m.length - 1) continue;
            str = str.append(sentenceDelimiter);
        }
        return str.toString();
    }

    public static String printIntArray(int[] m) {
        return ArrayString.printIntArray(new int[][]{m});
    }

    public static String printIntArray(int[][] m) {
        return ArrayString.printIntArray(m, defaultColumnDelimiter, defaultRowDelimiter);
    }

    public static String printIntArray(int[][] m, String wordDelimiter, String sentenceDelimiter) {
        StringBuffer str = new StringBuffer(25 * m.length * m[0].length);
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length - 1; ++j) {
                str = str.append(Integer.toString(m[i][j]));
                str = str.append(wordDelimiter);
            }
            str = str.append(Integer.toString(m[i][m[i].length - 1]));
            if (i >= m.length - 1) continue;
            str = str.append(sentenceDelimiter);
        }
        return str.toString();
    }

    public static double[] readString1DDouble(String s) {
        return ArrayString.readString1DDouble(s, defaultColumnDelimiter);
    }

    public static double[] readString1DDouble(String s, String columnDelimiter) {
        double[][] d = ArrayString.readStringDouble(s, columnDelimiter, NotFoundDelimiter);
        double[] d1D = null;
        if (d.length > 1) {
            d1D = new double[d.length];
            for (int i = 0; i < d1D.length; ++i) {
                d1D[i] = d[i][0];
            }
        } else {
            d1D = d[0];
        }
        return d1D;
    }

    public static int[] readString1DInt(String s) {
        return ArrayString.readString1DInt(s, defaultColumnDelimiter);
    }

    public static int[] readString1DInt(String s, String columnDelimiter) {
        int[][] d = ArrayString.readStringInt(s, columnDelimiter, NotFoundDelimiter);
        int[] d1D = null;
        if (d.length > 1) {
            d1D = new int[d.length];
            for (int i = 0; i < d1D.length; ++i) {
                d1D[i] = d[i][0];
            }
        } else {
            d1D = d[0];
        }
        return d1D;
    }

    public static double[][] readStringDouble(String s) {
        return ArrayString.readStringDouble(s, defaultColumnDelimiter, defaultRowDelimiter);
    }

    public static double[][] readStringDouble(String s, String columnDelimiter, String rowDelimiter) {
        String[] rows = null;
        rows = s.contains(rowDelimiter) ? s.split(rowDelimiter) : new String[]{s};
        double[][] array = new double[rows.length][];
        for (int i = 0; i < rows.length; ++i) {
            String[] cols = rows[i].split(columnDelimiter);
            array[i] = new double[cols.length];
            for (int j = 0; j < cols.length; ++j) {
                try {
                    array[i][j] = Double.parseDouble(cols[j]);
                    continue;
                }
                catch (NumberFormatException e) {
                    array[i][j] = Double.NaN;
                }
            }
        }
        return array;
    }

    public static int[][] readStringInt(String s) {
        return ArrayString.readStringInt(s, defaultColumnDelimiter, defaultRowDelimiter);
    }

    public static int[][] readStringInt(String s, String columnDelimiter, String rowDelimiter) {
        String[] rows = s.split(rowDelimiter);
        int[][] array = new int[rows.length][];
        for (int i = 0; i < rows.length; ++i) {
            String[] cols = rows[i].split(columnDelimiter);
            array[i] = new int[cols.length];
            for (int j = 0; j < cols.length; ++j) {
                try {
                    array[i][j] = Integer.parseInt(cols[j]);
                    continue;
                }
                catch (NumberFormatException e) {
                    array[i][j] = Integer.MAX_VALUE;
                }
            }
        }
        return array;
    }
}

