/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.math.plot.PlotPanel;
import org.math.plot.canvas.Plot3DCanvas;
import org.math.plot.canvas.PlotCanvas;

public class PlotToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    protected ButtonGroup buttonGroup;
    protected JToggleButton buttonCenter;
    protected JToggleButton buttonZoom;
    protected JToggleButton buttonRotate;
    protected JButton buttonSetScales;
    protected JButton buttonDatas;
    protected JButton buttonSavePNGFile;
    protected JButton buttonReset;
    protected JButton buttonAdjustBounds;
    private boolean denySaveSecurity;
    private JFileChooser pngFileChooser;
    private PlotCanvas plotCanvas;
    private PlotPanel plotPanel;
    boolean adjustBoundsVisible = true;

    public PlotToolBar(PlotPanel pp) {
        this.plotPanel = pp;
        this.plotCanvas = pp.plotCanvas;
        try {
            this.pngFileChooser = new JFileChooser();
            this.pngFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return "Portable Network Graphic file";
                }
            });
        }
        catch (AccessControlException ace) {
            this.denySaveSecurity = true;
        }
        this.buttonGroup = new ButtonGroup();
        this.buttonCenter = new JToggleButton(new ImageIcon(PlotPanel.class.getResource("icons/center.png")));
        this.buttonCenter.setToolTipText("Center axis");
        this.buttonCenter.setSelected(this.plotCanvas.ActionMode == 1);
        this.buttonZoom = new JToggleButton(new ImageIcon(PlotPanel.class.getResource("icons/zoom.png")));
        this.buttonZoom.setToolTipText("Zoom");
        this.buttonZoom.setSelected(this.plotCanvas.ActionMode == 0);
        this.buttonSetScales = new JButton(new ImageIcon(PlotPanel.class.getResource("icons/scale.png")));
        this.buttonSetScales.setToolTipText("Edit axis scales");
        this.buttonDatas = new JButton(new ImageIcon(PlotPanel.class.getResource("icons/data.png")));
        this.buttonDatas.setToolTipText("Get data");
        this.buttonSavePNGFile = new JButton(new ImageIcon(PlotPanel.class.getResource("icons/topngfile.png")));
        this.buttonSavePNGFile.setToolTipText("Save graphics in a .PNG File");
        this.buttonReset = new JButton(new ImageIcon(PlotPanel.class.getResource("icons/back.png")));
        this.buttonReset.setToolTipText("Reset zoom & axis");
        this.buttonAdjustBounds = new JButton(new ImageIcon(PlotPanel.class.getResource(this.plotCanvas.getAdjustBounds() ? "icons/adjustbounds.png" : "icons/noadjustbounds.png")));
        this.buttonAdjustBounds.setToolTipText("Auto-update/fix bounds");
        this.buttonZoom.setSelected(true);
        this.buttonZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PlotToolBar)PlotToolBar.this).plotCanvas.ActionMode = 0;
            }
        });
        this.buttonCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PlotToolBar)PlotToolBar.this).plotCanvas.ActionMode = 1;
            }
        });
        this.buttonSetScales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotCanvas.displayScalesFrame();
            }
        });
        this.buttonDatas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotCanvas.displayDataFrame();
            }
        });
        this.buttonSavePNGFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.choosePNGFile();
            }
        });
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotCanvas.resetBase();
            }
        });
        this.buttonAdjustBounds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotCanvas.setAdjustBounds(!PlotToolBar.this.plotCanvas.getAdjustBounds());
                PlotToolBar.this.ajustBoundsChanged();
            }
        });
        this.buttonGroup.add(this.buttonCenter);
        this.buttonGroup.add(this.buttonZoom);
        this.add((Component)this.buttonCenter, null);
        this.add((Component)this.buttonZoom, null);
        this.add((Component)this.buttonReset, null);
        this.add((Component)this.buttonSetScales, null);
        if (this.adjustBoundsVisible) {
            this.add((Component)this.buttonAdjustBounds, null);
        }
        this.add((Component)this.buttonSavePNGFile, null);
        this.add((Component)this.buttonDatas, null);
        if (!this.denySaveSecurity) {
            this.pngFileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotToolBar.this.saveGraphicFile();
                }
            });
        } else {
            this.buttonSavePNGFile.setEnabled(false);
        }
        if (this.plotCanvas instanceof Plot3DCanvas) {
            if (this.buttonRotate == null) {
                this.buttonRotate = new JToggleButton(new ImageIcon(PlotPanel.class.getResource("icons/rotation.png")));
                this.buttonRotate.setToolTipText("Rotate axes");
                this.buttonRotate.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((PlotToolBar)PlotToolBar.this).plotCanvas.ActionMode = 2;
                    }
                });
                this.buttonGroup.add(this.buttonRotate);
                this.add(this.buttonRotate, null, 2);
                this.buttonRotate.setSelected(this.plotCanvas.ActionMode == 2);
            } else {
                this.buttonRotate.setEnabled(true);
            }
        } else if (this.buttonRotate != null) {
            if (this.plotCanvas.ActionMode == 2) {
                this.plotCanvas.ActionMode = 0;
            }
            this.buttonRotate.setEnabled(false);
        }
    }

    void choosePNGFile() {
        this.pngFileChooser.showSaveDialog(this);
    }

    void saveGraphicFile() {
        File file = this.pngFileChooser.getSelectedFile();
        try {
            this.plotPanel.toGraphicFile(file);
        }
        catch (IOException e) {
            JOptionPane.showConfirmDialog(null, "Save failed : " + e.getMessage(), "Error", -1, 0);
        }
    }

    public void viewAdjustBounds(boolean visible) {
        if (visible && !this.adjustBoundsVisible) {
            this.add((Component)this.buttonAdjustBounds, null);
            this.adjustBoundsVisible = true;
        }
        if (!visible && this.adjustBoundsVisible) {
            this.remove(this.buttonAdjustBounds);
            this.adjustBoundsVisible = false;
        }
        this.ajustBoundsChanged();
    }

    public void ajustBoundsChanged() {
        this.buttonAdjustBounds.setIcon(new ImageIcon(PlotPanel.class.getResource(this.plotCanvas.getAdjustBounds() ? "icons/adjustbounds.png" : "icons/noadjustbounds.png")));
    }
}

