package org.openjump.core.rasterimage.styler.ui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.util.Collection;
import java.util.ResourceBundle;

import javax.swing.InputVerifier;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.Stats;
import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.RasterStylesExtension;
import org.openjump.core.rasterimage.styler.SLDHandler;
import org.openjump.core.rasterimage.styler.Utils;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;

import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.ui.ErrorDialog;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;

import de.fho.jump.pirol.utilities.settings.PirolPlugInSettings;

/**
 *
 * @author GeomaticaEAmbiente
 */
public class RasterStylesDialog extends javax.swing.JDialog {

    /**
     * Creates new form SymbologyDialog
     * @param parent parent frame
     * @param modal true if Dialog is modal
     * @param context Workbench Context
     * @param rasterImageLayer one of the selected RasterImageLayer
     * @param band raster band to symbolize
     */
    public RasterStylesDialog(java.awt.Frame parent, boolean modal, 
            WorkbenchContext context, RasterImageLayer rasterImageLayer, int band) throws Exception {
        
        super(parent, modal);
        this.context = context;
        this.rasterImageLayer = rasterImageLayer;
        this.band = band;
        
        try {
          initComponents();
          fixComponents();
        } catch (Exception e) {
          // survive exception during initialization
          Logger.error(e);
          context.getErrorHandler().handleThrowable(e);
        }
    }


    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    //@SuppressWarnings("unchecked")
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jTabbedPane_Type = new javax.swing.JTabbedPane();
        jPanel_OtherParams = new javax.swing.JPanel();
        jButton_NoDataValueColor = new javax.swing.JButton();
        jLabel_Transparency = new javax.swing.JLabel();
        jLabel_Transp_0 = new javax.swing.JLabel();
        jSlider_Transparency = new javax.swing.JSlider();
        jLabel_Transp_100 = new javax.swing.JLabel();
        jCheckBox_NoDataValue = new javax.swing.JCheckBox();
        jTextField_TranspValue = new javax.swing.JTextField();
        jButton_Load = new javax.swing.JButton();
        jButton_Save = new javax.swing.JButton();
        jButton_Cancel = new javax.swing.JButton();
        jButton_Restore = new javax.swing.JButton();
        jButton_Apply = new javax.swing.JButton();
        jButton_OK = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setMinimumSize(new java.awt.Dimension(420, 450));
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jTabbedPane_Type.setAlignmentX(1.0F);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jTabbedPane_Type, gridBagConstraints);

        jPanel_OtherParams.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel_OtherParams.setMinimumSize(new java.awt.Dimension(400, 100));
        jPanel_OtherParams.setPreferredSize(new java.awt.Dimension(400, 100));
        jPanel_OtherParams.setLayout(new java.awt.GridBagLayout());

        jButton_NoDataValueColor.setBackground(new java.awt.Color(204, 204, 204));
        jButton_NoDataValueColor.setForeground(new java.awt.Color(204, 204, 204));
        jButton_NoDataValueColor.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_NoDataValueColor.text")); // NOI18N
        jButton_NoDataValueColor.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jButton_NoDataValueColor.setContentAreaFilled(false);
        jButton_NoDataValueColor.setDoubleBuffered(true);
        jButton_NoDataValueColor.setMaximumSize(new java.awt.Dimension(40, 25));
        jButton_NoDataValueColor.setMinimumSize(new java.awt.Dimension(40, 25));
        jButton_NoDataValueColor.setOpaque(true);
        jButton_NoDataValueColor.setPreferredSize(new java.awt.Dimension(40, 25));
        jButton_NoDataValueColor.addActionListener(this::jButton_NoDataValueColorActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        jPanel_OtherParams.add(jButton_NoDataValueColor, gridBagConstraints);

        jLabel_Transparency.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jLabel_Transparency.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel_OtherParams.add(jLabel_Transparency, gridBagConstraints);

        jLabel_Transp_0.setBackground(new java.awt.Color(0, 0, 0));
        jLabel_Transp_0.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jLabel_Transp_0.text")); // NOI18N
        jLabel_Transp_0.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jLabel_Transp_0.setMaximumSize(new java.awt.Dimension(10, 10));
        jLabel_Transp_0.setMinimumSize(new java.awt.Dimension(10, 10));
        jLabel_Transp_0.setOpaque(true);
        jLabel_Transp_0.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        jPanel_OtherParams.add(jLabel_Transp_0, gridBagConstraints);

        jSlider_Transparency.setFont(new java.awt.Font("Tahoma", Font.PLAIN, 5)); // NOI18N
        jSlider_Transparency.setForeground(new java.awt.Color(102, 102, 102));
        jSlider_Transparency.setMajorTickSpacing(20);
        jSlider_Transparency.setMinorTickSpacing(5);
        jSlider_Transparency.setPaintTicks(true);
        jSlider_Transparency.setSnapToTicks(true);
        jSlider_Transparency.setValue(0);
        jSlider_Transparency.setMinimumSize(new java.awt.Dimension(150, 31));
        jSlider_Transparency.setPreferredSize(new java.awt.Dimension(150, 31));
        jSlider_Transparency.addChangeListener(this::jSlider_TransparencyStateChanged);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(9, 0, 0, 0);
        jPanel_OtherParams.add(jSlider_Transparency, gridBagConstraints);

        jLabel_Transp_100.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jLabel_Transp_100.text")); // NOI18N
        jLabel_Transp_100.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jLabel_Transp_100.setMaximumSize(new java.awt.Dimension(10, 10));
        jLabel_Transp_100.setMinimumSize(new java.awt.Dimension(10, 10));
        jLabel_Transp_100.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        jPanel_OtherParams.add(jLabel_Transp_100, gridBagConstraints);

        jCheckBox_NoDataValue.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jCheckBox_NoDataValue.text")); // NOI18N
        jCheckBox_NoDataValue.setMaximumSize(new java.awt.Dimension(70, 23));
        jCheckBox_NoDataValue.setMinimumSize(new java.awt.Dimension(70, 23));
        jCheckBox_NoDataValue.addActionListener(this::jCheckBox_NoDataValueActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel_OtherParams.add(jCheckBox_NoDataValue, gridBagConstraints);

        jTextField_TranspValue.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jTextField_TranspValue.text")); // NOI18N
        jTextField_TranspValue.setMinimumSize(new java.awt.Dimension(40, 20));
        jTextField_TranspValue.setPreferredSize(new java.awt.Dimension(40, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 20);
        jPanel_OtherParams.add(jTextField_TranspValue, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        getContentPane().add(jPanel_OtherParams, gridBagConstraints);

        jButton_Load.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_Load.text")); // NOI18N
        jButton_Load.addActionListener(this::jButton_LoadActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        getContentPane().add(jButton_Load, gridBagConstraints);

        jButton_Save.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_Save.text")); // NOI18N
        jButton_Save.addActionListener(this::jButton_SaveActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        getContentPane().add(jButton_Save, gridBagConstraints);

        jButton_Cancel.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_Cancel.text")); // NOI18N
        jButton_Cancel.addActionListener(this::jButton_CancelActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 10);
        getContentPane().add(jButton_Cancel, gridBagConstraints);

        jButton_Restore.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_Restore.text")); // NOI18N
        jButton_Restore.addActionListener(this::jButton_RestoreActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jButton_Restore, gridBagConstraints);

        jButton_Apply.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_Apply.text")); // NOI18N
        jButton_Apply.addActionListener(this::jButton_ApplyActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jButton_Apply, gridBagConstraints);

        jButton_OK.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_OK.text")); // NOI18N
        jButton_OK.addActionListener(this::jButton_OKActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jButton_OK, gridBagConstraints);

        pack();
    }

    private void jButton_NoDataValueColorActionPerformed(java.awt.event.ActionEvent evt) {

        if(jCheckBox_NoDataValue.isSelected()){            
            noDataColor =  JColorChooser.showDialog(
                    this,
                    I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.chooseNoDataColor"),
                    jButton_NoDataValueColor.getBackground()
            );
            
            if(noDataColor!=null){
                jButton_NoDataValueColor.setBackground(noDataColor);
            }
        }             
        
    }

    private void jCheckBox_NoDataValueActionPerformed(java.awt.event.ActionEvent evt) {
    
        jButton_NoDataValueColor.setEnabled(jCheckBox_NoDataValue.isSelected());        
        
    }

    private void jButton_LoadActionPerformed(java.awt.event.ActionEvent evt) {
        
        loadSld();
        
    }

    private void jButton_SaveActionPerformed(java.awt.event.ActionEvent evt) {
        
        saveSld();
        
    }

    private void jButton_CancelActionPerformed(java.awt.event.ActionEvent evt) {
        
        closeDialog();
        
    }

    private void jButton_ApplyActionPerformed(java.awt.event.ActionEvent evt) {
  
        //Update raster image
        try {         
            updateRasterImageLayer();
        } catch (Exception ex) {
            Logger.error(ex);
        }
        
    }

    private void jSlider_TransparencyStateChanged(javax.swing.event.ChangeEvent evt) {

        jTextField_TranspValue.setText(Integer.toString(jSlider_Transparency.getValue()));
        
    }

    private void jButton_RestoreActionPerformed(java.awt.event.ActionEvent evt) {
        
        try {
            Collection<Layerable> layerables = context.getLayerableNamePanel().getSelectedLayerables();
            for (Layerable lyr : layerables) {
                jButton_NoDataValueColor.setBackground(new java.awt.Color(204, 204, 204));
                jButton_NoDataValueColor.setForeground(new java.awt.Color(204, 204, 204));
                jSlider_Transparency.setValue(0);
                jTextField_TranspValue.setText("0");
                jCheckBox_NoDataValue.setSelected(false);
                stretchedPanel.reset();
                intervalPanel.reset();
                singleValuesPanel.reset();
                finalRasterSymbolizer.setColorMapType(RasterSymbology.TYPE_RAMP);
                if (lyr instanceof RasterImageLayer) restoreToOriginal((RasterImageLayer)lyr);
            }
        } catch (Exception ex) {
            Logger.error(ex);
        }
            
    }

    private void jButton_OKActionPerformed(java.awt.event.ActionEvent evt) {
        
        //Update raster image and close
        try {         
            updateRasterImageLayer();
            closeDialog();
        } catch (Exception ex) {
            Logger.error( ex);
        }
        
    }

    private void fixComponents() throws Exception {

      this.setTitle(RasterStylesExtension.extensionName);

      /* Transparency text field */
      jTextField_TranspValue.setInputVerifier(verifier);
      jTextField_TranspValue.addActionListener(verifier);
      jTextField_TranspValue.setText(Integer.toString(jSlider_Transparency.getValue()));

      Stats stats = rasterImageLayer.getMetadata().getStats();
      Range minMaxValues = new Range(stats.getMin(band), true, stats.getMax(band), true);
      double[] values = Utils.purgeNoData(this.rasterImageLayer.getRasterData(null), this.rasterImageLayer);
      stretchedPanel = new StretchedPanel(minMaxValues);
      intervalPanel = new IntervalPanel(this, rasterImageLayer, minMaxValues);
      singleValuesPanel = new SingleValuesPanel(this,
          Utils.purgeNoData(rasterImageLayer.getRasterData(null), rasterImageLayer), rasterImageLayer);

      if (stats.getMin(band) == stats.getMax(band)) {
        final DummyPanel pan = new DummyPanel(
            I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.no_stretched_only_one_value",stats.getMax(band)));
        jTabbedPane_Type
            .addTab(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabStretched"), pan);
        jTabbedPane_Type.addTab(
            I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabIntervals"), intervalPanel);
        for (final Component c2 : intervalPanel.getComponents()) {
          c2.setEnabled(false);
        }
        singleValuesPanel = new SingleValuesPanel(this,
            Utils.purgeNoData(rasterImageLayer.getRasterData(null), rasterImageLayer), rasterImageLayer);
        jTabbedPane_Type.addTab(
            I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabSingleValues"),
            singleValuesPanel);

      } else if (values.length > 2048) {

        jTabbedPane_Type.addTab(
            I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabStretched"),
            stretchedPanel);
        jTabbedPane_Type.addTab(
            I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabIntervals"), intervalPanel);
        final DummyPanel pan = new DummyPanel(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.no_single_too_many_values", values.length));
        jTabbedPane_Type.addTab(
            I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabSingleValues"), pan);
      } else {

        jTabbedPane_Type.addTab(
            I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabStretched"),
            stretchedPanel);
        jTabbedPane_Type.addTab(
            I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabIntervals"), intervalPanel);
        singleValuesPanel = new SingleValuesPanel(this,
            Utils.purgeNoData(rasterImageLayer.getRasterData(null), rasterImageLayer), rasterImageLayer);
        jTabbedPane_Type.addTab(
            I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabSingleValues"),
            singleValuesPanel);
      }
      pack();

      /* Startup symbology */
      if (rasterImageLayer.getSymbology() != null) {

        this.finalRasterSymbolizer = rasterImageLayer.getSymbology();
        updateGUI();

      }

      // add RasterSymbolizer Object in BlackBoard, the key is the name of raster plus
      // suffixBBoardKey var.
      String bboardKey = GUIUtils.getBBKey(String.valueOf(rasterImageLayer.getUUID()));
      context.getBlackboard().put(bboardKey, this);
    }

    public void updateRasterImageLayer() throws Exception {
        
        if(jTabbedPane_Type.getSelectedComponent() instanceof StretchedPanel) {
            finalRasterSymbolizer = stretchedPanel.getRasterStyler();
        } else if(jTabbedPane_Type.getSelectedComponent() instanceof IntervalPanel) {
            finalRasterSymbolizer = intervalPanel.getRasterStyler();
        } else if(jTabbedPane_Type.getSelectedComponent() instanceof SingleValuesPanel) {
            finalRasterSymbolizer = singleValuesPanel.getRasterStyler();
            
        }
        
        finalRasterSymbolizer.setTransparency(GUIUtils.getAlpha_DecimalRange(Integer.parseInt(jTextField_TranspValue.getText())));
        
        if(jCheckBox_NoDataValue.isSelected()){
            finalRasterSymbolizer.addColorMapEntry(rasterImageLayer.getNoDataValue(), jButton_NoDataValueColor.getBackground());
        } else {
            finalRasterSymbolizer.addColorMapEntry(rasterImageLayer.getNoDataValue(), null);
        }

        Collection<Layerable> layerables = context.getLayerableNamePanel().getSelectedLayerables();
        for (Layerable lyr : layerables) {
            if (lyr instanceof RasterImageLayer) apply((RasterImageLayer)lyr);
        }

    }

    public void apply(RasterImageLayer rasterImageLayer) throws Exception {
        rasterImageLayer.setSymbology(finalRasterSymbolizer);
        context.getLayerManager().fireLayerChanged(rasterImageLayer, LayerEventType.APPEARANCE_CHANGED);
    }

    private void restoreToOriginal(RasterImageLayer rasterImageLayer) throws NoninvertibleTransformException {
        rasterImageLayer.setSymbology(null);
    }
    
    private void saveSld() {
        
        if(finalRasterSymbolizer == null) {
            return;
        }
        
        JFileChooser chooser = new JFileChooser(PirolPlugInSettings.configDirectory());
        String extension = "sld";
        FileNameExtensionFilter filter = new FileNameExtensionFilter(
                I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.fileChooser.sld"), extension);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            
            try {
                File sldFile = chooser.getSelectedFile();
                if(!sldFile.getAbsolutePath().endsWith(extension)){
                    sldFile = new File(sldFile + "." + extension);
                }
                
                SLDHandler.write(finalRasterSymbolizer, null, sldFile);
            } catch (Exception ex) {
                ErrorDialog.show(this, StringUtil.toFriendlyName(
                        ex.getClass().getName()),
                        ex.toString(),
                        StringUtil.stackTrace(ex));
            }
        }
        
    }
    
    private void loadSld() {
                
        JFileChooser chooser = new JFileChooser(PirolPlugInSettings.configDirectory());
        FileNameExtensionFilter filter = new FileNameExtensionFilter(
                I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.fileChooser.sld"), "sld");
        chooser.setFileFilter(filter);
        chooser.setMultiSelectionEnabled(false);
        
        int returnVal = chooser.showOpenDialog(this);
        
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            
            try {
                File sldFile = chooser.getSelectedFile();
                finalRasterSymbolizer = SLDHandler.read(sldFile);

                // Update GUI
                updateGUI();
                
            } catch (Exception ex) {
                ErrorDialog.show(this, StringUtil.toFriendlyName(
                        ex.getClass().getName()),
                        ex.toString(),
                        StringUtil.stackTrace(ex));
            }
        }
        
    }
    
    private void closeDialog() {
        
        GUIUtils.clearRasterStylerFromBlackBoard(context);
        setVisible(false);
        
    }
    
    public double getNoDataValue() {
        return rasterImageLayer.getNoDataValue();
    }
    
    private void updateGUI() throws Exception {
        
        if(finalRasterSymbolizer.getColorMapType().equals(RasterSymbology.TYPE_RAMP)) {
                stretchedPanel.plugRasterSymbology(finalRasterSymbolizer);
                jTabbedPane_Type.setSelectedIndex(0);
        } else if(finalRasterSymbolizer.getColorMapType().equals(RasterSymbology.TYPE_INTERVALS)) {
                intervalPanel.plugRasterSymbology(finalRasterSymbolizer);
                jTabbedPane_Type.setSelectedIndex(1);
        } else if(finalRasterSymbolizer.getColorMapType().equals(RasterSymbology.TYPE_SINGLE)) {
                singleValuesPanel.plugRasterSymbology(finalRasterSymbolizer);
                jTabbedPane_Type.setSelectedIndex(2);
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton_Apply;
    private javax.swing.JButton jButton_Cancel;
    private javax.swing.JButton jButton_Load;
    private javax.swing.JButton jButton_NoDataValueColor;
    private javax.swing.JButton jButton_OK;
    private javax.swing.JButton jButton_Restore;
    private javax.swing.JButton jButton_Save;
    private javax.swing.JCheckBox jCheckBox_NoDataValue;
    private javax.swing.JLabel jLabel_Transp_0;
    private javax.swing.JLabel jLabel_Transp_100;
    private javax.swing.JLabel jLabel_Transparency;
    private javax.swing.JPanel jPanel_OtherParams;
    private javax.swing.JSlider jSlider_Transparency;
    private javax.swing.JTabbedPane jTabbedPane_Type;
    private javax.swing.JTextField jTextField_TranspValue;
    // End of variables declaration//GEN-END:variables

    private Color noDataColor;
    private final WorkbenchContext context;
    private final RasterImageLayer rasterImageLayer;
    private final int band;
    private StretchedPanel stretchedPanel;
    private IntervalPanel intervalPanel;
    private SingleValuesPanel singleValuesPanel;
    
    private final MyVerifier verifier = new MyVerifier();
    private RasterSymbology finalRasterSymbolizer;

    public RasterSymbology getFinalRasterSymbolizer() {
        return finalRasterSymbolizer;
    }
    
    class MyVerifier extends InputVerifier
            implements ActionListener {

        @Override
        public boolean verify(JComponent input) {
            
            String value = jTextField_TranspValue.getText();
            String sliderValue = Integer.toString(jSlider_Transparency.getValue());
            if(value == null || value.equals("")){ //NOI18N
                jTextField_TranspValue.setText(sliderValue);
            } else {
                try {
                    int number = Integer.parseInt(value);
                    if(number < 0 || number > 100) {
                        jTextField_TranspValue.setText(sliderValue);
                    } else {
                        jSlider_Transparency.setValue(number);
                    }
                } catch(NumberFormatException ex) {
                    jTextField_TranspValue.setText(sliderValue);
                }
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates. //NOI18N
        }
        
    }    
    
    private class DummyPanel extends JPanel implements StylePanel {

        private static final long serialVersionUID = 2217457292163045134L;

        private DummyPanel(String label) {
            // GridBagLayout so it gets centered. [Jon Aquino]
            super(new GridBagLayout());
            add(new JLabel(label));
        }

        @Override
        public String getTitle() {
            return ColorThemingStylePanel.TITLE;
        }

        @Override
        public void updateStyles() {
            // unused but defined in the interface
        }

        @Override
        public String validateInput() {
            return null;
        }
    }
}
