/*
 * Decompiled with CFR 0.152.
 */
package com.isa.jump.plugin;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.ScaleBarRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.RepaintManager;
import org.openjump.core.ui.plugin.view.NorthArrowRenderer;
import org.openjump.core.ui.plugin.view.helpclassescale.ShowScaleRenderer;

public class PrinterDriver
implements Printable {
    protected static final double dotsPerInch = 72.0;
    protected static final String PRINTING_PASS = "Printing (pass ";
    protected int printCallCount = 0;
    protected double printTotalHeight = 0.0;
    protected LayerViewPanel panel;
    protected TaskFrame taskFrame = null;
    protected boolean printBorder = false;
    protected PlugInContext context;
    protected int resolutionFactor = 1;
    protected ArrayList<Layerable> printLayerables = null;
    protected boolean singlePageMode = true;

    public ArrayList<Layerable> getPrintLayerables() {
        return this.printLayerables;
    }

    public void setPrintLayerables(ArrayList<Layerable> printLayerables) {
        this.printLayerables = printLayerables;
    }

    public boolean getSinglePageMode() {
        return this.singlePageMode;
    }

    public void setSinglePageMode(boolean singlePageMode) {
        this.singlePageMode = singlePageMode;
    }

    public boolean getPrintBorder() {
        return this.printBorder;
    }

    public void setPrintBorder(boolean printBorder) {
        this.printBorder = printBorder;
    }

    public int getResolutionFactor() {
        return this.resolutionFactor;
    }

    public void setResolutionFactor(int resolutionFactor) {
        this.resolutionFactor = resolutionFactor;
    }

    public PrinterDriver(PlugInContext context, LayerViewPanel panel) {
        this.context = context;
        this.panel = panel;
    }

    public void setTaskFrame(TaskFrame taskFrame) {
        this.taskFrame = taskFrame;
    }

    protected void render(Graphics2D graphics, Collection<Layerable> layersReversed) {
        ScaleBarRenderer renderer;
        for (Layerable layerable : layersReversed) {
            if (!layerable.isVisible()) continue;
            if (layerable instanceof Layer) {
                Layer layer = (Layer)layerable;
                LayerRenderer renderer2 = new LayerRenderer(layer, this.panel);
                renderer2.createRunnable();
                renderer2.getSimpleFeatureCollectionRenderer().copyTo(graphics);
                renderer2.clearImageCache();
                continue;
            }
            Renderer renderer3 = this.panel.getRenderingManager().createRenderer((Object)layerable);
            Runnable runnable = renderer3.createRunnable();
            if (runnable == null) continue;
            runnable.run();
            renderer3.copyTo(graphics);
            renderer3.clearImageCache();
        }
        if (ScaleBarRenderer.isEnabled((LayerViewPanel)this.panel)) {
            renderer = new ScaleBarRenderer(this.panel, this.taskFrame);
            renderer.copyTo(graphics);
            renderer.clearImageCache();
        }
        if (NorthArrowRenderer.isEnabled((LayerViewPanel)this.panel)) {
            renderer = new NorthArrowRenderer(this.panel);
            renderer.copyTo(graphics);
            renderer.clearImageCache();
        }
        if (ShowScaleRenderer.isEnabled((LayerViewPanel)this.panel)) {
            renderer = new ShowScaleRenderer(this.panel);
            renderer.copyTo(graphics);
            renderer.clearImageCache();
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (this.singlePageMode && page > 0) {
            return 1;
        }
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (this.printBorder) {
            Rectangle2D.Double pageBorder = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
            graphics.setPaint(Color.black);
            graphics.draw(pageBorder);
        }
        ++this.printCallCount;
        Rectangle r = graphics.getClipBounds();
        if (r != null) {
            int correctedPanelHeight = Math.round((float)this.panel.getHeight() / (float)this.resolutionFactor);
            if (r.height > correctedPanelHeight) {
                graphics.setClip(r.x, r.y, r.width, correctedPanelHeight);
            }
            int yBottom = r.y + r.height;
            if (this.printCallCount == 1) {
                this.printTotalHeight = yBottom;
                this.context.getWorkbenchFrame().setStatusMessage(PRINTING_PASS + this.printCallCount + ") Y = " + yBottom);
            } else {
                int percent = (int)((double)(100 * yBottom) / this.printTotalHeight);
                this.context.getWorkbenchFrame().setStatusMessage(PRINTING_PASS + this.printCallCount + ") % = " + percent);
            }
        }
        graphics.translate(pf.getImageableX(), pf.getImageableY());
        if ((double)this.resolutionFactor != 1.0) {
            graphics.scale(1.0 / (double)this.resolutionFactor, 1.0 / (double)this.resolutionFactor);
        }
        try {
            if (this.printLayerables != null) {
                this.render(graphics, this.printLayerables);
            } else {
                this.panel.getRenderingManager().setRenderingMode(2);
                this.panel.getRenderingManager().renderAll();
                this.panel.getRenderingManager().copyTo(graphics);
                this.panel.getRenderingManager().setRenderingMode(0);
            }
        }
        catch (Exception e) {
            String message = e.getMessage() == null ? e.toString() : e.getMessage();
            System.err.println(message);
            throw new PrinterException(message);
        }
        return 0;
    }

    public static ArrayList<Collection<Style>> optimizeForVectors(ArrayList<Layerable> printLayerables, boolean removeThemeFills, boolean removeBasicFill, boolean changeLineWidth, float lineWidthMultiplier, boolean removeTransparency) {
        if (!(removeThemeFills || removeBasicFill || changeLineWidth || removeTransparency)) {
            return null;
        }
        ArrayList<Collection<Style>> oldStyleList = new ArrayList<Collection<Style>>(printLayerables.size());
        for (Layerable layerable : printLayerables) {
            if (!(layerable instanceof Layer)) continue;
            Layer layer = (Layer)layerable;
            Collection oldStyles = layer.cloneStyles();
            oldStyleList.add(oldStyles);
            List currentStyles = layer.getStyles();
            for (Style style : currentStyles) {
                if (style instanceof BasicStyle) {
                    BasicStyle basicStyle = (BasicStyle)style;
                    if (removeTransparency) {
                        basicStyle.setAlpha(255);
                    }
                    if (removeBasicFill) {
                        basicStyle.setRenderingFill(false);
                    }
                    if (!changeLineWidth) continue;
                    float lineWidth = basicStyle.getLineWidth();
                    basicStyle.setFractionalLineWidth(lineWidth * lineWidthMultiplier);
                    continue;
                }
                if (!(style instanceof ColorThemingStyle)) continue;
                ColorThemingStyle themedStyle = (ColorThemingStyle)style;
                if (removeTransparency) {
                    themedStyle.setAlpha(255);
                }
                Map attributeValueToBasicStyleMap = themedStyle.getAttributeValueToBasicStyleMap();
                for (Map.Entry entry : attributeValueToBasicStyleMap.entrySet()) {
                    BasicStyle basicStyle = (BasicStyle)entry.getValue();
                    if (removeThemeFills) {
                        basicStyle.setRenderingFill(false);
                    }
                    if (!changeLineWidth) continue;
                    float lineWidth = basicStyle.getLineWidth();
                    basicStyle.setFractionalLineWidth(lineWidth * lineWidthMultiplier);
                }
            }
        }
        return oldStyleList;
    }

    public static PageFormat getPageFormat(PrintRequestAttributeSet attributeSet, PrinterJob printerJob) {
        Attribute[] atts;
        PageFormat pageFormat = printerJob.getPageFormat(attributeSet);
        for (Attribute att : atts = attributeSet.toArray()) {
            Paper paper;
            if (att instanceof MediaPrintableArea) {
                MediaPrintableArea printableArea = (MediaPrintableArea)att;
                paper = pageFormat.getPaper();
                float[] area = printableArea.getPrintableArea(25400);
                paper.setImageableArea((double)area[0] * 72.0, (double)area[1] * 72.0, (double)area[2] * 72.0, (double)area[3] * 72.0);
                pageFormat.setPaper(paper);
                continue;
            }
            if (att instanceof OrientationRequested) {
                OrientationRequested orientation = (OrientationRequested)att;
                if (orientation.equals(OrientationRequested.LANDSCAPE)) {
                    pageFormat.setOrientation(0);
                    continue;
                }
                if (orientation.equals(OrientationRequested.PORTRAIT)) {
                    pageFormat.setOrientation(1);
                    continue;
                }
                if (orientation.equals(OrientationRequested.REVERSE_LANDSCAPE)) {
                    pageFormat.setOrientation(2);
                    continue;
                }
                pageFormat.setOrientation(0);
                continue;
            }
            if (!(att instanceof MediaSize) && !(att instanceof MediaSizeName)) continue;
            MediaSize mediaSize = att instanceof MediaSizeName ? MediaSize.getMediaSizeForName((MediaSizeName)att) : (MediaSize)att;
            paper = pageFormat.getPaper();
            paper.setSize((double)mediaSize.getX(25400) * 72.0, (double)mediaSize.getY(25400) * 72.0);
            pageFormat.setPaper(paper);
        }
        return pageFormat;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

