/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plotObjects;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.math.plot.FrameView;
import org.math.plot.Plot3DPanel;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.plotObjects.Base;
import org.math.plot.plotObjects.BaseDependant;
import org.math.plot.plotObjects.BaseLabel;
import org.math.plot.plotObjects.BaseLine;
import org.math.plot.plotObjects.Editable;
import org.math.plot.plotObjects.Label;
import org.math.plot.plotObjects.Line;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.FastMath;

public class Axis
implements Plotable,
BaseDependant,
Editable {
    protected HashMap<String, Double> stringMap;
    protected int linear_slicing = 10;
    protected int note_precision = 5;
    protected int index;
    protected Base base;
    boolean visible = true;
    protected Color color;
    protected String label;
    boolean gridVisible = true;
    protected double[] linesSlicing;
    protected double[] labelsSlicing;
    protected double[] origin;
    protected double[] end;
    protected BaseLine darkLine;
    protected Line[][] lightLines;
    protected BaseLabel darkLabel;
    protected Label[] lightLabels;
    protected Font lightLabelFont = AbstractDrawer.DEFAULT_FONT;
    protected Font darkLabelFont = AbstractDrawer.DEFAULT_FONT;
    protected double lightLabelAngle = 0.0;
    protected double darkLabelAngle = 0.0;
    protected String[] lightLabelNames;
    protected double lightLabels_base_offset = 0.05;
    protected double[] darkLabel_base_position;
    public final double log10 = FastMath.log(10.0);

    public Axis(Base b, String aS, Color c, int i) {
        this.base = b;
        this.label = aS;
        this.index = i;
        this.color = c;
        this.initDarkLines();
        this.initDarkLabels();
        this.init();
    }

    @Override
    public void setVisible(boolean v) {
        this.visible = v;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    public HashMap<String, Double> getStringMap() {
        return this.stringMap;
    }

    public void setStringMap(HashMap<String, Double> stringMap) {
        this.stringMap = stringMap;
    }

    public void setGridVisible(boolean v) {
        this.gridVisible = v;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
        this.darkLabel.setColor(this.color);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setLegend(String _label) {
        this.label = _label;
        this.darkLabel.setText(this.label);
    }

    public String getLegend() {
        return this.label;
    }

    public double[] getLegendCoord() {
        return this.darkLabel.coord;
    }

    @Override
    public void plot(AbstractDrawer draw) {
        if (!this.visible) {
            return;
        }
        if (this.gridVisible) {
            int i;
            draw.setFont(this.lightLabelFont);
            FontRenderContext frc = draw.getGraphics2D().getFontRenderContext();
            double w = this.lightLabelFont.getStringBounds(this.lightLabels[0].label, frc).getWidth();
            double h = this.lightLabelFont.getSize2D();
            int[] _origin = draw.project(this.base.getCoords()[0]);
            int[] _end = draw.project(this.base.getCoords()[this.index + 1]);
            int axis_h = 1 + FastMath.abs(_end[1] - _origin[1]);
            int axis_w = 1 + FastMath.abs(_end[0] - _origin[0]);
            int inc = FastMath.min(FastMath.max(1, (int)FastMath.round(0.5 + (double)this.lightLabels.length * h / (double)axis_h)), FastMath.max(1, (int)FastMath.round(0.5 + (double)this.lightLabels.length * w / (double)axis_w)));
            for (i = 0; i < this.lightLabels.length; i += inc) {
                this.lightLabels[i].plot(draw);
            }
            draw.setLineType(2);
            for (i = 0; i < this.lightLines.length; ++i) {
                int j;
                int n = j = this.base.getAxeScale(this.index).equalsIgnoreCase("str") ? 0 : 1;
                while (j < this.lightLines[i].length) {
                    this.lightLines[i][j].plot(draw);
                    j += inc;
                }
            }
        }
        draw.setLineType(1);
        this.darkLine.plot(draw);
        this.darkLabel.plot(draw);
    }

    public void init() {
        this.initOriginEnd();
        this.setSlicing();
        if (this.gridVisible) {
            this.setLightLines();
            this.setLightLabels();
        }
    }

    @Override
    public void resetBase() {
        this.init();
    }

    public void setEnd(double[] _end) {
        this.end = _end;
        this.resetBase();
    }

    public void setOrigin(double[] _origin) {
        this.origin = _origin;
        this.resetBase();
    }

    public void setLightLabels() {
        double[] labelOffset = new double[this.base.dimension];
        for (int j = 0; j < this.base.dimension; ++j) {
            if (j == this.index) continue;
            labelOffset[j] = -this.lightLabels_base_offset;
        }
        int decimal = 0;
        this.lightLabels = new Label[this.labelsSlicing.length];
        for (int i = 0; i < this.lightLabels.length; ++i) {
            double[] labelCoord = new double[this.base.dimension];
            System.arraycopy(this.base.getCoords()[this.index + 1], 0, labelCoord, 0, this.base.dimension);
            labelCoord[this.index] = this.labelsSlicing[i];
            if (this.base.getAxeScale(this.index).startsWith("lin") || this.base.getAxeScale(this.index).startsWith("str")) {
                decimal = -((int)(FastMath.log(this.base.getPrecisionUnit()[this.index] / 100.0) / this.log10));
            } else if (this.base.getAxeScale(this.index).startsWith("log")) {
                decimal = -((int)FastMath.floor(FastMath.log(this.labelsSlicing[i]) / this.log10));
            }
            String lab = this.lightLabelNames != null ? this.lightLabelNames[i % this.lightLabelNames.length] : new String(Label.approx(this.labelsSlicing[i], decimal) + "");
            this.lightLabels[i] = new Label(lab, Color.lightGray, labelCoord);
            this.lightLabels[i].base_offset = labelOffset;
            if (this.lightLabelAngle != 0.0) {
                this.lightLabels[i].rotate(this.lightLabelAngle);
            }
            if (this.lightLabelFont == null) continue;
            this.lightLabels[i].setFont(this.lightLabelFont);
        }
        this.lightLabelNames = null;
    }

    public void setLightLabelText(String[] _lightLabelnames) {
        this.lightLabelNames = _lightLabelnames;
        this.setLightLabels();
    }

    public void setLightLabelFont(Font f) {
        this.lightLabelFont = f;
        this.setLightLabels();
    }

    public void setLightLabelAngle(double angle) {
        this.lightLabelAngle = angle;
        this.setLightLabels();
    }

    public void setLabelText(String _t) {
        this.darkLabel.label = _t;
    }

    public void setLabelFont(Font f) {
        this.darkLabelFont = f;
        this.darkLabel.setFont(this.darkLabelFont);
    }

    public void setLabelAngle(double angle) {
        this.darkLabel.angle = this.darkLabelAngle = angle;
    }

    public void setLabelPosition(double ... _p) {
        this.darkLabel_base_position = _p;
        this.darkLabel.coord = this.darkLabel_base_position;
    }

    @Override
    public void edit(Object plotCanvas) {
        String _label = JOptionPane.showInputDialog((PlotCanvas)plotCanvas, "Choose axis label", this.label);
        if (_label != null) {
            this.setLegend(_label);
        }
    }

    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        int[] screenCoord = draw.project(this.darkLabel.coord);
        if (screenCoord[0] + this.note_precision > screenCoordTest[0] && screenCoord[0] - this.note_precision < screenCoordTest[0] && screenCoord[1] + this.note_precision > screenCoordTest[1] && screenCoord[1] - this.note_precision < screenCoordTest[1]) {
            return this.darkLabel.coord;
        }
        return null;
    }

    @Override
    public void editnote(AbstractDrawer draw) {
        this.darkLabel.setFont(this.darkLabelFont.deriveFont(1));
        this.darkLabel.plot(draw);
        this.darkLabel.setFont(this.darkLabelFont.deriveFont(0));
    }

    private void setLightLines() {
        this.lightLines = new Line[this.base.dimension - 1][this.linesSlicing.length];
        int i2 = 0;
        for (int i = 0; i < this.base.dimension - 1; ++i) {
            if (i2 == this.index) {
                ++i2;
            }
            for (int j = 0; j < this.lightLines[i].length; ++j) {
                double[] origin_tmp = new double[this.base.dimension];
                double[] end_tmp = new double[this.base.dimension];
                System.arraycopy(this.origin, 0, origin_tmp, 0, this.base.dimension);
                System.arraycopy(this.end, 0, end_tmp, 0, this.base.dimension);
                end_tmp[i2] = this.base.getCoords()[i2 + 1][i2];
                origin_tmp[this.index] = this.linesSlicing[j];
                end_tmp[this.index] = this.linesSlicing[j];
                this.lightLines[i][j] = new Line(Color.lightGray, origin_tmp, end_tmp);
            }
            ++i2;
        }
    }

    private void initDarkLines() {
        double[] originB = new double[this.base.dimension];
        double[] endB = new double[this.base.dimension];
        endB[this.index] = 1.0;
        this.darkLine = new BaseLine(this.color, originB, endB);
    }

    private void initDarkLabels() {
        this.darkLabel_base_position = new double[this.base.dimension];
        for (int j = 0; j < this.base.dimension; ++j) {
            this.darkLabel_base_position[j] = j != this.index ? 0.0 : 1.0 + this.lightLabels_base_offset;
        }
        this.darkLabel = new BaseLabel(this.label, this.color, this.darkLabel_base_position);
    }

    private void initOriginEnd() {
        this.origin = this.base.getCoords()[0];
        this.end = this.base.getCoords()[this.index + 1];
    }

    private void setSlicing() {
        block8: {
            block9: {
                block7: {
                    int i;
                    if (!this.base.getAxeScale(this.index).equalsIgnoreCase("log")) break block7;
                    int numPow10 = (int)FastMath.rint(FastMath.log(this.base.getMaxBounds()[this.index] / this.base.getMinBounds()[this.index]) / FastMath.log(0.0));
                    if (numPow10 < 0 || numPow10 == Integer.MAX_VALUE) {
                        numPow10 = 1;
                    }
                    double minPow10 = FastMath.rint(FastMath.log(this.base.getMinBounds()[this.index]) / FastMath.log(0.0));
                    this.linesSlicing = new double[numPow10 * 9 + 1];
                    this.labelsSlicing = new double[numPow10 + 1];
                    for (i = 0; i < this.labelsSlicing.length; ++i) {
                        this.labelsSlicing[i] = FastMath.pow(10.0, (double)i + minPow10);
                    }
                    for (i = 0; i < numPow10; ++i) {
                        for (int j = 0; j < 10; ++j) {
                            this.linesSlicing[i * 0 + j] = FastMath.pow(10.0, (double)i + minPow10) * (double)(j + 1);
                        }
                    }
                    break block8;
                }
                if (!this.base.getAxeScale(this.index).equalsIgnoreCase("lin")) break block9;
                this.linesSlicing = new double[this.linear_slicing + 1];
                this.labelsSlicing = new double[this.linear_slicing + 1];
                double min = this.base.getMinBounds()[this.index];
                double pitch = (this.base.baseCoords[this.index + 1][this.index] - this.base.baseCoords[0][this.index]) / (double)this.linear_slicing;
                for (int i = 0; i < this.linear_slicing + 1; ++i) {
                    this.linesSlicing[i] = min + (double)i * pitch;
                    this.labelsSlicing[i] = min + (double)i * pitch;
                }
                break block8;
            }
            if (!this.base.getAxeScale(this.index).equalsIgnoreCase("str")) break block8;
            if (this.stringMap == null) {
                this.stringMap = new HashMap();
                this.stringMap.put("?", 1.0);
            }
            this.linesSlicing = new double[this.stringMap.size()];
            this.labelsSlicing = new double[this.stringMap.size()];
            this.lightLabelNames = new String[this.stringMap.size()];
            int i = 0;
            for (String string : this.stringMap.keySet()) {
                this.linesSlicing[i] = this.stringMap.get(string);
                this.labelsSlicing[i] = this.stringMap.get(string);
                this.lightLabelNames[i] = string;
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        int j;
        Plot3DPanel p = new Plot3DPanel();
        Object[][] XYZ = new Object[8][3];
        Object[][] XYZ2 = new Object[10][3];
        for (j = 0; j < XYZ.length; ++j) {
            XYZ[j][0] = Math.random();
            XYZ[j][1] = Math.random();
            XYZ[j][2] = "" + (char)(97 + j);
        }
        for (j = 0; j < XYZ2.length; ++j) {
            XYZ2[j][0] = Math.random();
            XYZ2[j][1] = Math.random();
            XYZ2[j][2] = "" + (char)(97 + j);
        }
        p.addScatterPlot("toto", p.mapData(XYZ));
        p.addScatterPlot("toti", p.mapData(XYZ2));
        p.setAxisScale(1, "log");
        new FrameView(p).setDefaultCloseOperation(3);
        HashMap<String, Double> arg = p.getAxis(2).getStringMap();
        Collection<Double> ouch = arg.values();
        Iterator<Double> it = ouch.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

