/*
 * Decompiled with CFR 0.152.
 */
package com.isa.jump.plugin;

import com.isa.jump.plugin.PrinterDriver;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLayer;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.ScaleBarRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openjump.core.ui.plugin.view.NorthArrowRenderer;
import org.openjump.core.ui.plugin.view.helpclassescale.ShowScaleRenderer;

public class PDFDriver
extends PrinterDriver {
    PdfContentByte pdfContentByte = null;
    PdfWriter writer = null;

    public PDFDriver(PlugInContext context, LayerViewPanel panel) {
        super(context, panel);
    }

    public PDFDriver(PlugInContext context, LayerViewPanel panel, PdfContentByte pdfContentByte, PdfWriter writer) {
        super(context, panel);
        this.pdfContentByte = pdfContentByte;
        this.writer = writer;
    }

    @Override
    protected void render(Graphics2D graphics, Collection<Layerable> layersReversed) {
        ScaleBarRenderer renderer;
        PdfLayer pdfLayer;
        PdfArray pdfArray = new PdfArray();
        ArrayList<PdfIndirectReference> pdfLayerRefs = new ArrayList<PdfIndirectReference>();
        for (Layerable layerable : layersReversed) {
            if (!layerable.isVisible()) continue;
            PdfLayer pdfLayer2 = new PdfLayer(layerable.getName(), this.writer);
            this.pdfContentByte.beginLayer((PdfOCG)pdfLayer2);
            if (layerable instanceof Layer) {
                Layer layer = (Layer)layerable;
                LayerRenderer renderer2 = new LayerRenderer(layer, this.panel);
                Runnable runnable = renderer2.createRunnable();
                if (layer.getBlackboard().get(RenderingManager.USE_MULTI_RENDERING_THREAD_QUEUE_KEY, false)) {
                    runnable.run();
                    renderer2.copyTo(graphics);
                } else {
                    renderer2.getSimpleFeatureCollectionRenderer().copyTo(graphics);
                }
                renderer2.clearImageCache();
            } else {
                Renderer renderer3 = this.panel.getRenderingManager().createRenderer((Object)layerable);
                Runnable runnable = renderer3.createRunnable();
                if (runnable == null) continue;
                runnable.run();
                renderer3.copyTo(graphics);
                renderer3.clearImageCache();
            }
            this.pdfContentByte.endLayer();
            pdfLayerRefs.add(pdfLayer2.getRef());
        }
        Collections.reverse(pdfLayerRefs);
        for (PdfIndirectReference ref : pdfLayerRefs) {
            pdfArray.add((PdfObject)ref);
        }
        if (ScaleBarRenderer.isEnabled((LayerViewPanel)this.panel)) {
            pdfLayer = new PdfLayer(ScaleBarRenderer.CONTENT_ID, this.writer);
            this.pdfContentByte.beginLayer((PdfOCG)pdfLayer);
            renderer = new ScaleBarRenderer(this.panel, this.taskFrame);
            renderer.copyTo(graphics);
            renderer.clearImageCache();
            this.pdfContentByte.endLayer();
            pdfArray.add((PdfObject)pdfLayer.getRef());
        }
        if (NorthArrowRenderer.isEnabled((LayerViewPanel)this.panel)) {
            pdfLayer = new PdfLayer("NORTH_ARROW", this.writer);
            this.pdfContentByte.beginLayer((PdfOCG)pdfLayer);
            renderer = new NorthArrowRenderer(this.panel);
            renderer.copyTo(graphics);
            renderer.clearImageCache();
            this.pdfContentByte.endLayer();
            pdfArray.add((PdfObject)pdfLayer.getRef());
        }
        if (ShowScaleRenderer.isEnabled((LayerViewPanel)this.panel)) {
            pdfLayer = new PdfLayer("SCALE_SHOW", this.writer);
            this.pdfContentByte.beginLayer((PdfOCG)pdfLayer);
            renderer = new ShowScaleRenderer(this.panel);
            renderer.copyTo(graphics);
            renderer.clearImageCache();
            this.pdfContentByte.endLayer();
            pdfArray.add((PdfObject)pdfLayer.getRef());
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.ORDER, (PdfObject)pdfArray);
        this.writer.getOCProperties().put(PdfName.D, (PdfObject)pdfDictionary);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (this.singlePageMode && page > 0) {
            return 1;
        }
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (this.printBorder) {
            Rectangle2D.Double pageBorder = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
            graphics.setPaint(Color.black);
            graphics.draw(pageBorder);
        }
        ++this.printCallCount;
        Rectangle r = graphics.getClipBounds();
        if (r != null) {
            int correctedPanelHeight = Math.round((float)this.panel.getHeight() / (float)this.resolutionFactor);
            if (r.height > correctedPanelHeight) {
                graphics.setClip(r.x, r.y, r.width, correctedPanelHeight);
            }
            int yBottom = r.y + r.height;
            if (this.printCallCount == 1) {
                this.printTotalHeight = yBottom;
                this.context.getWorkbenchFrame().setStatusMessage("Printing (pass " + this.printCallCount + ") Y = " + yBottom);
            } else {
                int percent = (int)((double)(100 * yBottom) / this.printTotalHeight);
                this.context.getWorkbenchFrame().setStatusMessage("Printing (pass " + this.printCallCount + ") % = " + percent);
            }
        }
        graphics.translate(pf.getImageableX(), pf.getImageableY());
        if ((double)this.resolutionFactor != 1.0) {
            graphics.scale(1.0 / (double)this.resolutionFactor, 1.0 / (double)this.resolutionFactor);
        }
        try {
            this.render(graphics, this.printLayerables);
        }
        catch (Exception e) {
            String message = e.getMessage() == null ? e.toString() : e.getMessage();
            System.err.println(message);
            throw new PrinterException(message);
        }
        return 0;
    }

    public PdfContentByte getCb() {
        return this.pdfContentByte;
    }

    public void setCb(PdfContentByte pdfContentByte) {
        this.pdfContentByte = pdfContentByte;
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PdfWriter writer) {
        this.writer = writer;
    }
}

