package org.openjump.core.rasterimage.styler.ui;

import javax.swing.JOptionPane;

import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.RasterStylesExtension;

import com.vividsolutions.jump.workbench.Logger;

import java.awt.*;

/**
 *
 * @author GeomaticaEAmbiente
 */
public class CustomGradientColorsDialog extends javax.swing.JDialog {

    /**
     * Creates new form CustomGradientColors
     * @param parent the parent Frame
     * @param modal true if the Dialog must be modal
     * @param colorMapEntries an array of ColorMapEntries
     */
   
    public CustomGradientColorsDialog(Frame parent, boolean modal, ColorMapEntry[] colorMapEntries) {
        super(parent, modal);
        
        this.colorMapEntries = colorMapEntries;
        initComponents();
        fixComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel_ColorTable = new javax.swing.JPanel();
        jButton_RemoveRow = new javax.swing.JButton();
        jButton_AddRow = new javax.swing.JButton();
        jPanel_Table = new javax.swing.JPanel();
        jPanel_Gradient = new javax.swing.JPanel();
        jLabel_Min = new javax.swing.JLabel();
        jLabel_Max = new javax.swing.JLabel();
        jButton_Cancel = new javax.swing.JButton();
        jButton_Ok = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setMinimumSize(new java.awt.Dimension(340, 220));
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel_ColorTable.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jPanel_ColorTable.setMinimumSize(new java.awt.Dimension(300, 200));
        jPanel_ColorTable.setPreferredSize(new java.awt.Dimension(320, 150));
        jPanel_ColorTable.setLayout(new java.awt.GridBagLayout());

        jButton_RemoveRow.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jButton_RemoveRow.text")); // NOI18N
        jButton_RemoveRow.setToolTipText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jButton_RemoveRow.toolTipText")); // NOI18N
        jButton_RemoveRow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_RemoveRowActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 2);
        jPanel_ColorTable.add(jButton_RemoveRow, gridBagConstraints);

        jButton_AddRow.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jButton_AddRow.text")); // NOI18N
        jButton_AddRow.setMaximumSize(new java.awt.Dimension(93, 23));
        jButton_AddRow.setMinimumSize(new java.awt.Dimension(93, 23));
        jButton_AddRow.setPreferredSize(new java.awt.Dimension(93, 23));
        jButton_AddRow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_AddRowActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 5, 5);
        jPanel_ColorTable.add(jButton_AddRow, gridBagConstraints);

        jPanel_Table.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel_Table.setMinimumSize(new java.awt.Dimension(250, 80));
        jPanel_Table.setPreferredSize(new java.awt.Dimension(250, 80));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanel_ColorTable.add(jPanel_Table, gridBagConstraints);

        jPanel_Gradient.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel_Gradient.setMinimumSize(new java.awt.Dimension(40, 80));
        jPanel_Gradient.setPreferredSize(new java.awt.Dimension(40, 80));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        jPanel_ColorTable.add(jPanel_Gradient, gridBagConstraints);

        jLabel_Min.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jLabel_Min.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        jPanel_ColorTable.add(jLabel_Min, gridBagConstraints);

        jLabel_Max.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jLabel_Max.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 0, 10);
        jPanel_ColorTable.add(jLabel_Max, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        getContentPane().add(jPanel_ColorTable, gridBagConstraints);

        jButton_Cancel.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jButton_Cancel.text")); // NOI18N
        jButton_Cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        getContentPane().add(jButton_Cancel, gridBagConstraints);

        jButton_Ok.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog.jButton_Ok.text")); // NOI18N
        jButton_Ok.setMaximumSize(new java.awt.Dimension(65, 23));
        jButton_Ok.setMinimumSize(new java.awt.Dimension(65, 23));
        jButton_Ok.setPreferredSize(new java.awt.Dimension(65, 23));
        jButton_Ok.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_OkActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        getContentPane().add(jButton_Ok, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton_AddRowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_AddRowActionPerformed

        addRow();
        
    }//GEN-LAST:event_jButton_AddRowActionPerformed

    private void jButton_RemoveRowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_RemoveRowActionPerformed

        removeRow();
        
    }//GEN-LAST:event_jButton_RemoveRowActionPerformed

    private void jButton_CancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_CancelActionPerformed

        colorMapEntries = null;
        dispose();
        
    }//GEN-LAST:event_jButton_CancelActionPerformed

    private void jButton_OkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_OkActionPerformed
        
        try {
            okButton();
        } catch (Exception ex) {
            Logger.error(ex);
        }
        
        
    }//GEN-LAST:event_jButton_OkActionPerformed

    private void fixComponents(){

        this.setTitle(RasterStylesExtension.extensionName);
        
        colorsTablePanel = new GradientTablePanel(this, ColorsTablePanel.TableType.VALUES,
        colorMapEntries, -9999.0, false, jPanel_Gradient);      
        
        colorsTablePanel.setMinimumSize(new java.awt.Dimension(250, 80));
        colorsTablePanel.setPreferredSize(new java.awt.Dimension(250, 80)); 
                
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        
        jPanel_ColorTable.remove(jPanel_Table);
       
        jPanel_ColorTable.add(colorsTablePanel, gridBagConstraints);
        
        //update gradient panel
        GUIUtils utils = new GUIUtils();
        utils.setGradientPanel(jPanel_Gradient, colorMapEntries);
        
        validate();
    }
    
    /**
     * Method to memorize the colors in the table in ColorMapEntry object.
     * @throws Exception if an Exception occurred
     */
    private void okButton() throws Exception{
        
        //Checks values
        ColorMapEntry[] cme = colorsTablePanel.getColorMapEntries();
        
        //Check if colors are more than 1
        if(cme.length < 2){
            JOptionPane.showMessageDialog(this, 
                    I18N.get("org.openjump.core.rasterimage.styler.ui.GradientTablePanel.ColorsNumber.message"), 
                    RasterStylesExtension.extensionName, 
                    JOptionPane.INFORMATION_MESSAGE);
            return;
        }        
        
        //Memorizes fraction values
        double[] values = new double[cme.length];        
        for(int n=0; n<values.length; n++){
            values[n] = cme[n].getUpperValue();
        }
        
        //Checks if fraction are in ascending order and if there are two equal values
        double tempValue = values[0];
        for(int v=1; v<values.length; v++){
            if(values[v] <= tempValue ||  values[v]>1){

                    JOptionPane.showMessageDialog(this, 
                            I18N.get("org.openjump.core.rasterimage.styler.ui.GradientTablePanel.FractionValues.message"), 
                            RasterStylesExtension.extensionName, 
                            JOptionPane.INFORMATION_MESSAGE);
                return;
            }
            tempValue = values[v];
        } 
        
        colorMapEntries = cme;
        dispose();
        
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton_AddRow;
    private javax.swing.JButton jButton_Cancel;
    private javax.swing.JButton jButton_Ok;
    private javax.swing.JButton jButton_RemoveRow;
    private javax.swing.JLabel jLabel_Max;
    private javax.swing.JLabel jLabel_Min;
    private javax.swing.JPanel jPanel_ColorTable;
    private javax.swing.JPanel jPanel_Gradient;
    private javax.swing.JPanel jPanel_Table;
    // End of variables declaration//GEN-END:variables

    private GradientTablePanel colorsTablePanel;
    private ColorMapEntry[] colorMapEntries;

    public ColorMapEntry[] getColorMapEntries(){
        return colorMapEntries;
    }
    
    private void addRow(){
        colorsTablePanel.addRows();
    }
    
    private void removeRow() {
        colorsTablePanel.removeRow();
    }
    
}
