/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.ToolTipEvent;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class BToolTip
extends Widget {
    private static BToolTip currentTip;
    private static Popup tipWindow;

    public BToolTip() {
        this.component = this.createComponent();
    }

    public BToolTip(String text) {
        this();
        this.setText(text);
    }

    protected JToolTip createComponent() {
        return new JToolTip();
    }

    public JToolTip getComponent() {
        return (JToolTip)this.component;
    }

    public String getText() {
        return this.getComponent().getTipText();
    }

    public void setText(String text) {
        this.getComponent().setTipText(text);
        this.invalidateSize();
    }

    public void show(Widget widget, Point where) {
        BToolTip.hide();
        Point basePos = widget.getComponent().getLocationOnScreen();
        tipWindow = PopupFactory.getSharedInstance().getPopup(widget.getComponent(), this.getComponent(), basePos.x + where.x, basePos.y + where.y);
        tipWindow.show();
        currentTip = this;
    }

    public void processEvent(ToolTipEvent event) {
        Widget widget = event.getWidget();
        Point where = event.getToolTipLocation();
        Window window = SwingUtilities.getWindowAncestor(widget.getComponent());
        if (window != null) {
            where = SwingUtilities.convertPoint(widget.getComponent(), where, window);
            Dimension winSize = window.getSize();
            Dimension tipSize = this.getPreferredSize();
            if (where.x + tipSize.width > winSize.width) {
                where.x = Math.max(0, winSize.width - tipSize.width);
            }
            if (where.y + tipSize.height > winSize.height) {
                where.y = Math.max(0, winSize.height - tipSize.height);
            }
            where = SwingUtilities.convertPoint(window, where, widget.getComponent());
        }
        this.show(widget, where);
    }

    public static BToolTip getShowingToolTip() {
        return currentTip;
    }

    public static void hide() {
        if (tipWindow != null) {
            tipWindow.hide();
        }
        tipWindow = null;
        currentTip = null;
    }
}

