/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.write;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryOutputStream;
import org.apache.commons.imaging.formats.tiff.write.AbstractTiffImageWriter;
import org.apache.commons.imaging.formats.tiff.write.AbstractTiffOutputItem;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSummary;

public class TiffImageWriterLossy
extends AbstractTiffImageWriter {
    public TiffImageWriterLossy() {
    }

    public TiffImageWriterLossy(ByteOrder byteOrder) {
        super(byteOrder);
    }

    private void updateOffsetsStep(List<AbstractTiffOutputItem> outputItems) {
        int offset = 8;
        for (AbstractTiffOutputItem outputItem : outputItems) {
            outputItem.setOffset(offset);
            int itemLength = outputItem.getItemLength();
            offset += itemLength;
            int remainder = TiffImageWriterLossy.imageDataPaddingLength(itemLength);
            offset += remainder;
        }
    }

    @Override
    public void write(OutputStream os, TiffOutputSet outputSet) throws IOException, ImagingException {
        TiffOutputSummary outputSummary = this.validateDirectories(outputSet);
        List<AbstractTiffOutputItem> outputItems = outputSet.getOutputItems(outputSummary);
        this.updateOffsetsStep(outputItems);
        outputSummary.updateOffsets(this.byteOrder);
        BinaryOutputStream bos = BinaryOutputStream.create(os, this.byteOrder);
        this.writeStep(bos, outputItems);
    }

    private void writeStep(BinaryOutputStream bos, List<AbstractTiffOutputItem> outputItems) throws IOException, ImagingException {
        this.writeImageFileHeader(bos);
        for (AbstractTiffOutputItem outputItem : outputItems) {
            outputItem.writeItem(bos);
            int length = outputItem.getItemLength();
            int remainder = TiffImageWriterLossy.imageDataPaddingLength(length);
            for (int j = 0; j < remainder; ++j) {
                bos.write(0);
            }
        }
    }
}

