/*
 * The Unified Mapping Platform (JUMP) is an extensible, interactive GUI 
 * for visualizing and manipulating spatial features with geometry and attributes.
 *
 * Copyright (C) 2003 Vivid Solutions
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For more information, contact:
 *
 * Vivid Solutions
 * Suite #1A
 * 2328 Government Street
 * Victoria BC  V8T 5G5
 * Canada
 *
 * (250)385-6040
 * www.vividsolutions.com
 */

package com.vividsolutions.jump.workbench.ui.wizard;

import java.util.Map;

import com.vividsolutions.jump.workbench.ui.InputChangedListener;


public interface WizardPanel {

    /**
     * Called when the user presses Next on this panel's previous panel
     * @param dataMap the dataMap containing all parameters
     */
    void enteredFromLeft(Map<String,Object> dataMap);

    /**
     * Called when the user presses Next on this panel
     * @throws Exception if an Exception occurs
     */
    void exitingToRight() throws Exception;

    /**
     * Tip: Delegate to an InputChangedFirer.
     * @param listener a party to notify when the input changes (usually the
     * WizardDialog, which needs to know when to update the enabled state of
     * the buttons.
     */
    void add(InputChangedListener listener);

    void remove(InputChangedListener listener);

    String getTitle();

    String getID();

    String getInstructions();

    boolean isInputValid();

    /**
     * @return null to turn the Next button into a Finish button
     */
    String getNextID();
}
