/*
 * The Unified Mapping Platform (JUMP) is an extensible, interactive GUI
 * for visualizing and manipulating spatial features with geometry and attributes.
 *
 * Copyright (C) 2003 Vivid Solutions
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * For more information, contact:
 *
 * Vivid Solutions
 * Suite #1A
 * 2328 Government Street
 * Victoria BC  V8T 5G5
 * Canada
 *
 * (250)385-6040
 * www.vividsolutions.com
 */
package com.vividsolutions.jump.workbench.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JComponent;
import javax.swing.JFrame;

import com.vividsolutions.jump.workbench.JUMPWorkbench;


/**
 * Based on "Java Tip 104: Make a splash with Swing" by Tony Colston
 * (http://www.javaworld.com/javaworld/javatips/jw-javatip104.html)
 */
public class SplashWindow extends JFrame {
    public SplashWindow(JComponent contents) {
        super();

        // attach icon early to prevent jdk default icon in task bar
        JUMPWorkbench.setIcon(this);

        setUndecorated(true);
        setCursor(new Cursor(Cursor.WAIT_CURSOR));
        if (SplashPanelV2.transparentSplash())
          setBackground(new Color(255,255,255,0));
        setContentPane(contents);
        //getContentPane().add(contents, BorderLayout.CENTER);
        pack();

        //System.out.println("SPLASH "+GUIUtil.isPerPixelTranslucencySupported()+"/"+
        //GUIUtil.isShapedWindowSupported()+"/"+GUIUtil.isUniformTranslucencySupported());
        
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = contents.getPreferredSize();
        setLocation((screenSize.width / 2) - (labelSize.width / 2),
            (screenSize.height / 2) - (labelSize.height / 2));
    }
}
