/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.render;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.utils.Array;

public abstract class AbstractDrawer {
    public PlotCanvas canvas;
    protected Graphics2D comp2D;
    public static final int ROUND_DOT = 1;
    public static final int CROSS_DOT = 2;
    public static final int PATTERN_DOT = 0;
    public static final int CONTINOUS_LINE = 1;
    public static final int DOTTED_LINE = 2;
    public static final int DEFAULT_DOT_RADIUS = 2;
    public static final int DEFAULT_LINE_WIDTH = 1;
    public static final boolean[][] DOT_TRIANGLE_PATTERN = AbstractDrawer.stringToPattern("_", "___#___", "__#_#__", "__#_#__", "_#___#_", "_#___#_", "#######");
    public static final boolean[][] DOT_SQUARE_PATTERN = AbstractDrawer.stringToPattern("_", "######", "#____#", "#____#", "#____#", "#____#", "######");
    public static final Font DEFAULT_FONT = new Font("Arial", 0, 10);
    public static final Color DEFAULT_COLOR = Color.BLACK;
    protected Font font = DEFAULT_FONT;
    protected double text_Eastoffset;
    protected double text_Northoffset;
    protected double text_angle;
    protected Color color = DEFAULT_COLOR;
    protected double[] base_offset;
    protected int[] screen_offset;
    protected int dot_type = 1;
    protected int dot_radius = 2;
    protected boolean[][] dot_pattern = DOT_TRIANGLE_PATTERN;
    protected int line_type = 1;
    protected int line_width = 1;

    public AbstractDrawer(PlotCanvas _canvas) {
        this.canvas = _canvas;
    }

    public void initGraphics(Graphics2D _comp2D) {
        this.comp2D = _comp2D;
        this.comp2D.setPaintMode();
    }

    public Graphics2D getGraphics2D() {
        return this.comp2D;
    }

    public abstract void resetBaseProjection();

    public void setColor(Color c) {
        this.color = c;
    }

    public abstract void setGradient(double[] var1, Color var2, double[] var3, Color var4);

    public void resetGradient() {
        this.comp2D.setPaint(this.color);
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public void setTextOffset(double _cornerEast, double _cornerNorth) {
        this.text_Eastoffset = _cornerEast;
        this.text_Northoffset = _cornerNorth;
    }

    public void setTextAngle(double _angle) {
        this.text_angle = _angle;
    }

    public void setDotType(int _dot_type) {
        this.dot_type = _dot_type;
    }

    public void setDotRadius(int _dot_radius) {
        this.dot_radius = _dot_radius;
    }

    public void setDotPattern(boolean[][] _dot_pattern) {
        this.dot_pattern = _dot_pattern;
    }

    public void setLineType(int _line_type) {
        this.line_type = _line_type;
    }

    public void setLineWidth(int _line_width) {
        this.line_width = _line_width;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setBaseOffset(double ... _boffset) {
        this.base_offset = _boffset;
    }

    public void setScreenOffset(int ... _soffset) {
        this.screen_offset = _soffset;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public double[] getTextOffset() {
        return new double[]{this.text_Eastoffset, this.text_Northoffset};
    }

    public double getTextAngle() {
        return this.text_angle;
    }

    public int getDotType() {
        return this.dot_type;
    }

    public int getDotRadius() {
        return this.dot_radius;
    }

    public boolean[][] getDotPattern() {
        return this.dot_pattern;
    }

    public double[] getBaseOffset() {
        return this.base_offset;
    }

    public int[] getScreenOffset() {
        return this.screen_offset;
    }

    public abstract int[] project(double ... var1);

    public abstract int[] projectBase(double ... var1);

    public abstract void translate(int ... var1);

    public abstract void dilate(int[] var1, double[] var2);

    public void drawCoordinate(double ... pC) {
        for (int i = 0; i < this.canvas.base.dimension; ++i) {
            double[] axeprojection = Array.copy(pC);
            axeprojection[i] = this.canvas.base.baseCoords[0][i];
            this.drawLine(pC, axeprojection);
        }
        this.setTextAngle(0.0);
        this.setTextOffset(0.0, 0.0);
    }

    public abstract void drawText(String var1, double ... var2);

    public abstract void drawShadowedText(String var1, float var2, double ... var3);

    public abstract void drawTextBase(String var1, double ... var2);

    public abstract void drawLineBase(double[] ... var1);

    public abstract void drawLine(double[] ... var1);

    public void drawDot(double ... pC) {
        switch (this.dot_type) {
            case 1: {
                this.drawRoundDot(pC);
                break;
            }
            case 2: {
                this.drawCrossDot(pC);
                break;
            }
            case 0: {
                this.drawPatternDot(pC);
            }
        }
    }

    public abstract void drawRoundDot(double ... var1);

    public abstract void drawCrossDot(double ... var1);

    public abstract void drawPatternDot(double ... var1);

    public abstract void drawPolygon(double[] ... var1);

    public abstract void fillPolygon(float var1, double[] ... var2);

    public abstract void drawImage(Image var1, float var2, double[] var3, double[] var4, double[] var5);

    public static boolean[][] stringToPattern(String empty, String ... c) {
        boolean[][] p = new boolean[c.length][];
        for (int i = 0; i < p.length; ++i) {
            p[i] = AbstractDrawer.stringToPattern(empty, c[i]);
        }
        return p;
    }

    public static boolean[] stringToPattern(String empty, String c) {
        boolean[] p = new boolean[c.length()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = !c.substring(i, i + 1).equals(empty);
        }
        return p;
    }
}

