/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.BScrollPane;
import buoy.widget.TextWidget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.EventSourceDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class BTextArea
extends TextWidget {
    public static final WrapStyle WRAP_NONE = new WrapStyle();
    public static final WrapStyle WRAP_CHARACTER = new WrapStyle();
    public static final WrapStyle WRAP_WORD = new WrapStyle();

    public BTextArea() {
        this(null, 0, 0);
    }

    public BTextArea(String text) {
        this(text, 0, 0);
    }

    public BTextArea(int rows, int columns) {
        this(null, rows, columns);
    }

    public BTextArea(String text, int rows, int columns) {
        this.component = this.createComponent();
        JTextArea ta = this.getComponent();
        ta.setText(text);
        ta.setRows(rows);
        ta.setColumns(columns);
        ta.addCaretListener(this.caretListener);
        ta.getDocument().addDocumentListener(this.documentListener);
    }

    protected JTextArea createComponent() {
        return new JTextArea();
    }

    public JTextArea getComponent() {
        return (JTextArea)this.component;
    }

    public int getRows() {
        return this.getComponent().getRows();
    }

    public void setRows(int rows) {
        this.getComponent().setRows(rows);
        this.invalidateSize();
    }

    public int getColumns() {
        return this.getComponent().getColumns();
    }

    public void setColumns(int columns) {
        this.getComponent().setColumns(columns);
        this.invalidateSize();
    }

    public int getLineCount() {
        return this.getComponent().getLineCount();
    }

    public WrapStyle getWrapStyle() {
        if (!this.getComponent().getLineWrap()) {
            return WRAP_NONE;
        }
        if (this.getComponent().getWrapStyleWord()) {
            return WRAP_WORD;
        }
        return WRAP_CHARACTER;
    }

    public void setWrapStyle(WrapStyle style) {
        JTextArea ta = this.getComponent();
        if (style == WRAP_NONE) {
            ta.setLineWrap(false);
        } else if (style == WRAP_CHARACTER) {
            ta.setLineWrap(true);
            ta.setWrapStyleWord(false);
        } else if (style == WRAP_WORD) {
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
        }
        this.invalidateSize();
    }

    public int getTabSize() {
        return this.getComponent().getTabSize();
    }

    public void setTabSize(int size) {
        this.getComponent().setTabSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String text) {
        try {
            ++this.suppressEvents;
            this.getComponent().append(text);
        }
        finally {
            --this.suppressEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String text, int pos) {
        try {
            ++this.suppressEvents;
            this.getComponent().insert(text, pos);
        }
        finally {
            --this.suppressEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceRange(String text, int start, int end) {
        try {
            ++this.suppressEvents;
            this.getComponent().replaceRange(text, start, end);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public Dimension getMinimumSize() {
        Dimension min = super.getMinimumSize();
        if (this.getWrapStyle() != WRAP_NONE) {
            min.width = 0;
        }
        return min;
    }

    protected void textChanged() {
        super.textChanged();
        if (this.getParent() instanceof BScrollPane) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BTextArea.this.getParent().layoutChildren();
                }
            });
        }
    }

    static {
        WidgetEncoder.setPersistenceDelegate(BTextArea.class, new EventSourceDelegate(new String[]{"text"}));
        WidgetEncoder.setPersistenceDelegate(WrapStyle.class, new StaticFieldDelegate(BTextArea.class));
    }

    public static class WrapStyle {
        private WrapStyle() {
        }
    }
}

