/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.internal.SingleWidgetPanel;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.IndexedContainerDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTabbedPane
extends WidgetContainer {
    private ArrayList<Widget> child;
    private int suppressEvents;
    public static final TabPosition TOP = new TabPosition(1);
    public static final TabPosition LEFT = new TabPosition(2);
    public static final TabPosition BOTTOM = new TabPosition(3);
    public static final TabPosition RIGHT = new TabPosition(4);

    public BTabbedPane() {
        this(TOP);
    }

    public BTabbedPane(TabPosition pos) {
        this.component = this.createComponent(pos);
        this.getComponent().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                if (BTabbedPane.this.suppressEvents == 0) {
                    BTabbedPane.this.dispatchEvent(new SelectionChangedEvent(BTabbedPane.this));
                }
            }
        });
        this.getComponent().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ev) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BTabbedPane.this.layoutChildren();
                    }
                });
            }
        });
        this.child = new ArrayList();
    }

    protected JTabbedPane createComponent(TabPosition pos) {
        return new JTabbedPane(pos.value);
    }

    @Override
    public JTabbedPane getComponent() {
        return (JTabbedPane)this.component;
    }

    @Override
    public int getChildCount() {
        return this.child.size();
    }

    public Widget getChild(int i) {
        return this.child.get(i);
    }

    @Override
    public Collection<Widget> getChildren() {
        return new ArrayList<Widget>(this.child);
    }

    @Override
    public void layoutChildren() {
        this.getComponent().validate();
        for (int i = 0; i < this.child.size(); ++i) {
            Widget w = this.child.get(i);
            if (!(w instanceof WidgetContainer)) continue;
            ((WidgetContainer)w).layoutChildren();
        }
    }

    public void add(Widget widget, String tabName) {
        this.add(widget, tabName, null, this.child.size());
    }

    public void add(Widget widget, String tabName, Icon image) {
        this.add(widget, tabName, image, this.child.size());
    }

    public void add(Widget widget, String tabName, Icon image, int index) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child.add(index, widget);
        this.getComponent().insertTab(tabName, image, new SingleWidgetPanel(widget), null, index);
        this.setAsParent(widget);
        this.invalidateSize();
    }

    @Override
    public void remove(Widget widget) {
        int index = this.child.indexOf(widget);
        if (index > -1) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        Widget w = this.child.get(index);
        this.getComponent().remove(index);
        this.child.remove(index);
        this.removeAsParent(w);
        this.invalidateSize();
    }

    @Override
    public void removeAll() {
        this.getComponent().removeAll();
        for (int i = 0; i < this.child.size(); ++i) {
            this.removeAsParent(this.child.get(i));
        }
        this.child.clear();
        this.invalidateSize();
    }

    public int getChildIndex(Widget widget) {
        return this.child.indexOf(widget);
    }

    public TabPosition getTabPosition() {
        switch (this.getComponent().getTabPlacement()) {
            case 1: {
                return TOP;
            }
            case 2: {
                return LEFT;
            }
            case 3: {
                return BOTTOM;
            }
        }
        return RIGHT;
    }

    public void setTabPosition(TabPosition pos) {
        this.getComponent().setTabPlacement(pos.value);
    }

    public String getTabName(int index) {
        return this.getComponent().getTitleAt(index);
    }

    public void setTabName(int index, String name) {
        this.getComponent().setTitleAt(index, name);
    }

    public Icon getTabImage(int index) {
        return this.getComponent().getIconAt(index);
    }

    public void setTabImage(int index, Icon image) {
        this.getComponent().setIconAt(index, image);
    }

    public int getSelectedTab() {
        return this.getComponent().getSelectedIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedTab(int index) {
        try {
            ++this.suppressEvents;
            this.getComponent().setSelectedIndex(index);
        }
        finally {
            --this.suppressEvents;
        }
    }

    static {
        WidgetEncoder.setPersistenceDelegate(TabPosition.class, new StaticFieldDelegate(BTabbedPane.class));
        WidgetEncoder.setPersistenceDelegate(BTabbedPane.class, new IndexedContainerDelegate(new String[]{"getChild", "getTabName", "getTabImage"}));
    }

    public static class TabPosition {
        protected int value;

        private TabPosition(int value) {
            this.value = value;
        }
    }
}

