/*
 * Decompiled with CFR 0.152.
 */
package com.isa.jump.plugin;

import com.isa.jump.plugin.PDFDriver;
import com.isa.jump.plugin.PrinterDriver;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.ScaleBarRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.ui.plugin.view.NorthArrowRenderer;
import org.openjump.core.ui.plugin.view.helpclassescale.ShowScaleRenderer;
import org.openjump.core.ui.util.ScreenScale;

public class PrintPlugIn
extends AbstractPlugIn {
    public static final String PRINT_PLUGIN_NAME = "SkyPrinterPlugin";
    public static final String PRINT_PLUGIN_VERSION = "2.0";
    public static final double INCH = 72.0;
    public static final double MILLIMETER = 2.834645669291339;
    public double UNIT = 2.834645669291339;
    I18N i18n = I18N.getInstance((String)"com.isa.jump.plugin");
    private final String PRINT_MENU = this.i18n.get("PrintPlugIn.Print", new Object[0]);
    private final String REMOVE_TRANSPARENCY = this.i18n.get("PrintPlugIn.Remove-Transparency", new Object[0]);
    private final String REMOVE_BASIC_FILLS = this.i18n.get("PrintPlugIn.Remove-basic-fills", new Object[0]);
    private final String REMOVE_THEME_FILLS = this.i18n.get("PrintPlugIn.Remove-theme-fills", new Object[0]);
    private final String CHANGE_LINE_WIDTH = this.i18n.get("PrintPlugIn.Change-line-width", new Object[0]);
    private final String LINE_WIDTH_PERCENT = this.i18n.get("PrintPlugIn.Line-width-percent", new Object[0]);
    private final String LINE_WIDTH_TOOLTIP = this.i18n.get("PrintPlugIn.Line-width-tooltip", new Object[0]);
    private final String PDF_PAGE_TOOLTIP = this.i18n.get("PrintPlugIn.PDF-page-tooltip", new Object[0]);
    private final String PRINT_BORDER = this.i18n.get("PrintPlugIn.Print-border", new Object[0]);
    private final String PRINT_OPTIONS = this.i18n.get("PrintPlugIn.Print-options", new Object[0]);
    private final String PRINTER_NOT_FOUND = this.i18n.get("PrintPlugIn.Printer-not-found", new Object[0]);
    private final String RESOLUTION_MULTIPLIER = this.i18n.get("PrintPlugIn.Resolution-multiplier", new Object[0]);
    private final String EXPAND_TO_FIT = this.i18n.get("PrintPlugIn.Expand-to-fit", new Object[0]);
    private final String PRINT_AREA_IN_FENCE = this.i18n.get("PrintPlugIn.Print-area-in-fence", new Object[0]);
    private final String PRINT_AREA_IN_BOUNDS = this.i18n.get("PrintPlugIn.Print-area-in-selection-bounds", new Object[0]);
    private final String FINISHED_MESSAGE = this.i18n.get("PrintPlugIn.Finished-message", new Object[0]);
    private final String PRINT_TO_PDF = this.i18n.get("PrintPlugIn.Print-to-PDF", new Object[0]);
    private final String PDF_META_TITLE = this.i18n.get("PrintPlugIn.PDF-title", new Object[0]);
    private final String PDF_META_SUBJECT = this.i18n.get("PrintPlugIn.PDF-subject", new Object[0]);
    private final String PDF_META_AUTHOR = this.i18n.get("PrintPlugIn.PDF-author", new Object[0]);
    private final String PDF_META_KEYWORDS = this.i18n.get("PrintPlugIn.PDF-keywords", new Object[0]);
    private final String PDF_META_TITLE_TOOLTIP = this.i18n.get("PrintPlugIn.PDF-title-tooltip", new Object[0]);
    private final String PDF_META_SUBJECT_TOOLTIP = this.i18n.get("PrintPlugIn.PDF-subject-tooltip", new Object[0]);
    private final String PDF_META_AUTHOR_TOOLTIP = this.i18n.get("PrintPlugIn.PDF-author-tooltip", new Object[0]);
    private final String PDF_META_KEYWORDS_TOOLTIP = this.i18n.get("PrintPlugIn.PDF-keywords-tooltip", new Object[0]);
    private final String SAVE_PDF = this.i18n.get("PrintPlugIn.Save-PDF", new Object[0]);
    private final String PDF_FILES = this.i18n.get("PrintPlugIn.PDF-files", new Object[0]);
    private final String PDF_PAGE_WIDTH = this.i18n.get("PrintPlugIn.PDF-page-width", new Object[0]);
    private final String PDF_PAGE_HEIGHT = this.i18n.get("PrintPlugIn.PDF-page-height", new Object[0]);
    private final String PAPER_SIZE = this.i18n.get("PrintPlugIn.Paper-size", new Object[0]);
    private final String PAPER_SIZE_TOOLTIP = this.i18n.get("PrintPlugIn.Please-select-the-papersize", new Object[0]);
    private final String PAPER_SIZE_CUSTOM = this.i18n.get("PrintPlugIn.custom-papersize", new Object[0]);
    private final String PORTRAIT = this.i18n.get("PrintPlugIn.Portait", new Object[0]);
    private final String LANDSCAPE = this.i18n.get("PrintPlugIn.Landscape", new Object[0]);
    private final String PORTRAIT_TOOLTIP = this.i18n.get("PrintPlugIn.Portrait-orientation", new Object[0]);
    private final String LANDSCAPE_TOOLTIP = this.i18n.get("PrintPlugIn.Landscape-orientation", new Object[0]);
    private final String ORIENTATION_BUTTON_GROUP = "orientationButtonGroup";
    private final String DATE_FORMAT_STRING = this.i18n.get("PrintPlugIn.dateFormatString", new Object[0]);
    private final String PDF_SUBJECT = this.i18n.get("PrintPlugIn.PDF-Subject", new Object[0]);
    private final String SCALE_PRINT = this.i18n.get("PrintPlugIn.scale", new Object[0]);
    private final String SCALE_PRINT_TOOLTIP = this.i18n.get("PrintPlugIn.scale-true-printing", new Object[0]);
    private final String SCALE_MAXIMUM_VIEW = this.i18n.get("PrintPlugIn.scale-maximum-view", new Object[0]);
    private final String SCALE_FULL_EXTENT = this.i18n.get("PrintPlugIn.scale-full-extent", new Object[0]);
    private boolean printToPDF = false;
    private PlugInContext pluginContext;
    private PrintService printService = null;
    private LayerViewPanel printPanel = null;
    private int resolutionFactor = 1;
    private boolean removeTransparency = false;
    private boolean removeThemeFills = false;
    private boolean removeBasicFills = false;
    private boolean changeLineWidth = true;
    private double lineWidthPercent = 25.0;
    private float lineWidthMultiplier = 0.0f;
    private boolean printBorder = false;
    private boolean expandToFit = true;
    private boolean printFenceArea = false;
    private boolean printBoundsArea = true;
    private boolean doubleImageResolution = false;
    PrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet();
    private ArrayList<Layerable> printLayerables;
    private Envelope windowEnvelope = null;
    private Geometry fence = null;
    private JCheckBox printAreaInBoundsCheckBox;
    private JCheckBox printBorderCheckBox;
    private JTextField pdfTitleTextField;
    private JTextField pdfSubjectTextField;
    private JTextField pdfAuthorTextField;
    private JTextField pdfKeywordsTextField;
    private double pdfPageWidth = 210.0;
    private double pdfPageHeight = 297.0;
    private JTextField pageWidthTextField;
    private JTextField pageHeightTextField;
    private boolean landscapeOrientation = false;
    private Object mediaSizeNameObject = MediaSizeName.ISO_A4;
    private String scaleValue;

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.attributeSet;
    }

    public void setPrintRequestAttributeSet(PrintRequestAttributeSet attributeSet) {
        this.attributeSet = attributeSet;
    }

    public void initialize(PlugInContext context) {
        context.getFeatureInstaller().addMainMenuPlugin((PlugIn)this, new String[]{MenuNames.FILE}, this.PRINT_MENU, false, null, (EnableCheck)PrintPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public boolean execute(PlugInContext context) {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.PRINT_OPTIONS, true);
        this.fence = context.getLayerViewPanel().getFence();
        this.printFenceArea = this.fence != null;
        dialog.addCheckBox(this.REMOVE_TRANSPARENCY, this.removeTransparency);
        dialog.addCheckBox(this.EXPAND_TO_FIT, this.expandToFit);
        dialog.addCheckBox(this.PRINT_AREA_IN_FENCE, this.printFenceArea);
        dialog.getCheckBox(this.PRINT_AREA_IN_FENCE).setEnabled(context.getLayerViewPanel().getFence() != null);
        this.printBoundsArea = this.printFenceArea ? false : context.getLayerViewPanel().getSelectionManager().getSelectedItems().size() == 1;
        this.printAreaInBoundsCheckBox = dialog.addCheckBox(this.PRINT_AREA_IN_BOUNDS, this.printBoundsArea);
        this.printAreaInBoundsCheckBox.setEnabled(this.printBoundsArea);
        dialog.getCheckBox(this.PRINT_AREA_IN_FENCE).addActionListener(e -> {
            this.printBoundsArea = !((JCheckBox)e.getSource()).isSelected() && context.getLayerViewPanel().getSelectionManager().getSelectedItems().size() == 1;
            this.printAreaInBoundsCheckBox.setEnabled(this.printBoundsArea);
            if (!this.printBoundsArea) {
                this.printAreaInBoundsCheckBox.setSelected(false);
            }
        });
        dialog.addCheckBox(this.PRINT_BORDER, this.printBorder);
        this.printBorderCheckBox = dialog.getCheckBox(this.PRINT_BORDER);
        dialog.addCheckBox(this.REMOVE_BASIC_FILLS, this.removeBasicFills);
        dialog.addCheckBox(this.REMOVE_THEME_FILLS, this.removeThemeFills);
        dialog.addCheckBox(this.CHANGE_LINE_WIDTH, this.changeLineWidth);
        dialog.addDoubleField(this.LINE_WIDTH_PERCENT, this.lineWidthPercent, 4, this.LINE_WIDTH_TOOLTIP);
        dialog.addCheckBox(this.RESOLUTION_MULTIPLIER, this.doubleImageResolution);
        dialog.addCheckBox(this.PRINT_TO_PDF, this.printToPDF);
        dialog.getCheckBox(this.PRINT_TO_PDF).addActionListener(e -> {
            JCheckBox printToPdfCheckBox = (JCheckBox)e.getSource();
            if (printToPdfCheckBox.isSelected()) {
                this.printBorderCheckBox.setEnabled(false);
                this.pdfTitleTextField.setEnabled(true);
                this.pdfSubjectTextField.setEnabled(true);
                this.pdfAuthorTextField.setEnabled(true);
                this.pdfKeywordsTextField.setEnabled(true);
            } else {
                this.printBorderCheckBox.setEnabled(true);
                this.pdfTitleTextField.setEnabled(false);
                this.pdfSubjectTextField.setEnabled(false);
                this.pdfAuthorTextField.setEnabled(false);
                this.pdfKeywordsTextField.setEnabled(false);
            }
        });
        this.pdfTitleTextField = dialog.addTextField("     " + this.PDF_META_TITLE, context.getTask().getName(), 20, null, this.PDF_META_TITLE_TOOLTIP);
        this.pdfSubjectTextField = dialog.addTextField("     " + this.PDF_META_SUBJECT, this.PDF_SUBJECT, 20, null, this.PDF_META_SUBJECT_TOOLTIP);
        this.pdfAuthorTextField = dialog.addTextField("     " + this.PDF_META_AUTHOR, System.getProperty("user.name"), 20, null, this.PDF_META_AUTHOR_TOOLTIP);
        this.pdfKeywordsTextField = dialog.addTextField("     " + this.PDF_META_KEYWORDS, "OpenJUMP", 20, null, this.PDF_META_KEYWORDS_TOOLTIP);
        this.pdfTitleTextField.setEnabled(this.printToPDF);
        this.pdfSubjectTextField.setEnabled(this.printToPDF);
        this.pdfAuthorTextField.setEnabled(this.printToPDF);
        this.pdfKeywordsTextField.setEnabled(this.printToPDF);
        dialog.addComboBox(this.PAPER_SIZE, (Object)MediaSizeName.ISO_A4, Arrays.asList(MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.NA_LETTER, this.PAPER_SIZE_CUSTOM), this.PAPER_SIZE_TOOLTIP);
        dialog.getComboBox(this.PAPER_SIZE).addActionListener(e -> {
            this.mediaSizeNameObject = ((JComboBox)e.getSource()).getSelectedItem();
            if (this.mediaSizeNameObject instanceof MediaSizeName) {
                MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)this.mediaSizeNameObject);
                this.pageWidthTextField.setEnabled(false);
                this.pageHeightTextField.setEnabled(false);
                if (this.landscapeOrientation) {
                    this.pageWidthTextField.setText(String.valueOf(mediaSize.getY(1000)));
                    this.pageHeightTextField.setText(String.valueOf(mediaSize.getX(1000)));
                } else {
                    this.pageWidthTextField.setText(String.valueOf(mediaSize.getX(1000)));
                    this.pageHeightTextField.setText(String.valueOf(mediaSize.getY(1000)));
                }
            } else {
                this.pageWidthTextField.setEnabled(true);
                this.pageHeightTextField.setEnabled(true);
            }
        });
        this.pageWidthTextField = dialog.addDoubleField(this.PDF_PAGE_WIDTH, this.pdfPageWidth, 4, this.PDF_PAGE_TOOLTIP);
        this.pageHeightTextField = dialog.addDoubleField(this.PDF_PAGE_HEIGHT, this.pdfPageHeight, 4, this.PDF_PAGE_TOOLTIP);
        this.pageWidthTextField.setEnabled(false);
        this.pageHeightTextField.setEnabled(false);
        dialog.addRadioButton(this.PORTRAIT, "orientationButtonGroup", true, this.PORTRAIT_TOOLTIP);
        dialog.addRadioButton(this.LANDSCAPE, "orientationButtonGroup", false, this.LANDSCAPE_TOOLTIP);
        dialog.getRadioButton(this.LANDSCAPE).addChangeListener(e -> {
            if (((JRadioButton)e.getSource()).isSelected()) {
                if (!this.landscapeOrientation) {
                    this.landscapeOrientation = true;
                    String oldWidth = this.pageWidthTextField.getText();
                    this.pageWidthTextField.setText(this.pageHeightTextField.getText());
                    this.pageHeightTextField.setText(oldWidth);
                }
            } else if (this.landscapeOrientation) {
                this.landscapeOrientation = false;
                String oldWidth = this.pageWidthTextField.getText();
                this.pageWidthTextField.setText(this.pageHeightTextField.getText());
                this.pageHeightTextField.setText(oldWidth);
            }
        });
        int actualScale = (int)Math.floor(ScreenScale.getHorizontalMapScale((Viewport)context.getLayerViewPanel().getViewport()));
        int[] scaleFactors = new int[]{actualScale, 100, 1000, 2500, 5000, 10000};
        Arrays.sort(scaleFactors);
        String[] stringScaleFactors = new String[scaleFactors.length + 2];
        for (int i = 0; i < scaleFactors.length; ++i) {
            stringScaleFactors[i] = "1:" + scaleFactors[i];
        }
        stringScaleFactors[scaleFactors.length] = this.SCALE_MAXIMUM_VIEW;
        stringScaleFactors[scaleFactors.length + 1] = this.SCALE_FULL_EXTENT;
        dialog.addComboBox(this.SCALE_PRINT, (Object)("1:" + actualScale), Arrays.asList(stringScaleFactors), this.SCALE_PRINT_TOOLTIP);
        dialog.getComboBox(this.SCALE_PRINT).setEditable(true);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            this.removeTransparency = dialog.getBoolean(this.REMOVE_TRANSPARENCY);
            this.expandToFit = dialog.getBoolean(this.EXPAND_TO_FIT);
            this.printFenceArea = dialog.getBoolean(this.PRINT_AREA_IN_FENCE);
            this.printBoundsArea = dialog.getBoolean(this.PRINT_AREA_IN_BOUNDS);
            this.printToPDF = dialog.getBoolean(this.PRINT_TO_PDF);
            this.printBorder = dialog.getBoolean(this.PRINT_BORDER) && !this.printToPDF;
            this.removeBasicFills = dialog.getBoolean(this.REMOVE_BASIC_FILLS);
            this.removeThemeFills = dialog.getBoolean(this.REMOVE_THEME_FILLS);
            this.changeLineWidth = dialog.getBoolean(this.CHANGE_LINE_WIDTH);
            this.lineWidthPercent = dialog.getDouble(this.LINE_WIDTH_PERCENT);
            this.lineWidthMultiplier = (float)this.lineWidthPercent / 100.0f;
            this.doubleImageResolution = dialog.getBoolean(this.RESOLUTION_MULTIPLIER);
            this.resolutionFactor = this.doubleImageResolution ? 2 : 1;
            this.pdfPageWidth = dialog.getDouble(this.PDF_PAGE_WIDTH);
            this.pdfPageHeight = dialog.getDouble(this.PDF_PAGE_HEIGHT);
            this.mediaSizeNameObject = dialog.getComboBox(this.PAPER_SIZE).getSelectedItem();
            this.scaleValue = (String)dialog.getComboBox(this.SCALE_PRINT).getSelectedItem();
            new Thread(() -> {
                try {
                    int oldScreenResolution = ScreenScale.getResolution();
                    ScreenScale.setResolution((int)72);
                    if (this.printToPDF) {
                        this.pdfCurrentWindow(context);
                    } else {
                        this.printCurrentWindow(context);
                    }
                    ScreenScale.setResolution((int)oldScreenResolution);
                }
                catch (PrinterException e) {
                    context.getErrorHandler().handleThrowable((Throwable)e);
                }
                context.getLayerViewPanel().repaint();
            }).start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pdfCurrentWindow(PlugInContext context) {
        JFileChooser fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting();
        fileChooser.setDialogTitle(this.SAVE_PDF);
        fileChooser.setDialogType(1);
        fileChooser.setMultiSelectionEnabled(false);
        GUIUtil.removeChoosableFileFilters((JFileChooser)fileChooser);
        FileFilter fileFilter1 = GUIUtil.createFileFilter((String)this.PDF_FILES, (String[])new String[]{"pdf"});
        fileChooser.addChoosableFileFilter(fileFilter1);
        fileChooser.setFileFilter(fileFilter1);
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        SimpleDateFormat df = new SimpleDateFormat(this.DATE_FORMAT_STRING);
        String dateStr = df.format(date);
        String suggestedFileName = context.getTask().getName() + "_" + dateStr + ".pdf";
        fileChooser.setSelectedFile(new File(suggestedFileName));
        String FILE_CHOOSER_DIRECTORY_KEY = SaveFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";
        String lastOutputDirectory = (String)PersistentBlackboardPlugIn.get((WorkbenchContext)context.getWorkbenchContext()).get(FILE_CHOOSER_DIRECTORY_KEY);
        if (lastOutputDirectory != null) {
            fileChooser.setCurrentDirectory(new File(lastOutputDirectory));
        }
        if (0 != fileChooser.showSaveDialog((Component)context.getLayerViewPanel())) {
            return;
        }
        PersistentBlackboardPlugIn.get((WorkbenchContext)context.getWorkbenchContext()).put(FILE_CHOOSER_DIRECTORY_KEY, (Object)fileChooser.getCurrentDirectory().getAbsolutePath());
        String pdfFileName = fileChooser.getSelectedFile().getPath();
        if (!pdfFileName.toLowerCase().endsWith(".pdf")) {
            pdfFileName = pdfFileName + ".pdf";
        }
        this.pluginContext = context;
        this.printLayerables = new ArrayList(context.getLayerManager().getLayerables(Layerable.class));
        Collections.reverse(this.printLayerables);
        ArrayList<Collection<Style>> oldStyleList = PrinterDriver.optimizeForVectors(this.printLayerables, this.removeThemeFills, this.removeBasicFills, this.changeLineWidth, this.lineWidthMultiplier, this.removeTransparency);
        Throwable[] throwable = new Throwable[]{null};
        this.printPanel = this.createLayerPanel(context.getLayerManager(), throwable);
        PDFDriver.disableDoubleBuffering((Component)this.printPanel);
        PDFDriver pdfDriver = new PDFDriver(context, this.printPanel);
        ScaleBarRenderer.setEnabled((boolean)ScaleBarRenderer.isEnabled((LayerViewPanel)context.getLayerViewPanel()), (LayerViewPanel)this.printPanel);
        NorthArrowRenderer.setEnabled((boolean)NorthArrowRenderer.isEnabled((LayerViewPanel)context.getLayerViewPanel()), (LayerViewPanel)this.printPanel);
        ShowScaleRenderer.setEnabled((boolean)ShowScaleRenderer.isEnabled((LayerViewPanel)context.getLayerViewPanel()), (LayerViewPanel)this.printPanel);
        pdfDriver.setTaskFrame((TaskFrame)context.getWorkbenchFrame().getActiveInternalFrame());
        pdfDriver.setPrintBorder(this.printBorder);
        pdfDriver.setPrintLayerables(this.printLayerables);
        this.windowEnvelope = this.pluginContext.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        this.fence = this.pluginContext.getLayerViewPanel().getFence();
        try {
            try {
                String message;
                Document document = new Document(new Rectangle((float)(this.pdfPageWidth * this.UNIT), (float)(this.pdfPageHeight * this.UNIT)));
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdfFileName));
                writer.setCropBoxSize(new Rectangle(0.0f, 0.0f, (float)(this.pdfPageWidth * this.UNIT), (float)(this.pdfPageHeight * this.UNIT)));
                writer.setPdfVersion('5');
                writer.setViewerPreferences(1024);
                document.open();
                document.addAuthor(this.pdfAuthorTextField.getText());
                document.addCreator("OpenJUMP SkyPrinterPlugin 2.0");
                document.addKeywords(this.pdfKeywordsTextField.getText());
                document.addSubject(this.pdfSubjectTextField.getText());
                document.addTitle(this.pdfTitleTextField.getText());
                DefaultFontMapper mapper = new DefaultFontMapper();
                FontFactory.registerDirectories();
                PageFormat pageFormat = new PageFormat();
                Paper paper = new Paper();
                double width = this.pdfPageWidth * this.UNIT;
                double height = this.pdfPageHeight * this.UNIT;
                paper.setSize(width, height);
                paper.setImageableArea(0.0, 0.0, width, height);
                pageFormat.setPaper(paper);
                double w = pageFormat.getImageableWidth();
                double h = pageFormat.getImageableHeight();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate tp = cb.createTemplate((float)w, (float)h);
                Graphics2D g2 = tp.createGraphics((float)w, (float)h, (FontMapper)mapper);
                tp.setWidth((float)w);
                tp.setHeight((float)h);
                pdfDriver.setCb((PdfContentByte)tp);
                pdfDriver.setWriter(writer);
                try {
                    this.initLayerViewPanel(pageFormat);
                    pdfDriver.setResolutionFactor(this.resolutionFactor);
                }
                catch (Exception e) {
                    message = e.getMessage() == null ? e.toString() : e.getMessage();
                    System.err.println(message);
                }
                try {
                    pdfDriver.print(g2, pageFormat, 0);
                }
                catch (PrinterException e) {
                    message = e.getMessage() == null ? e.toString() : e.getMessage();
                    System.err.println(message);
                }
                g2.dispose();
                tp.sanityCheck();
                cb.addTemplate(tp, 0.0f, 0.0f);
                cb.sanityCheck();
                document.close();
            }
            catch (DocumentException | IOException de) {
                System.err.println(de.getMessage());
            }
        }
        finally {
            if (oldStyleList != null) {
                boolean wasFiringEvents = this.printPanel.getLayerManager().isFiringEvents();
                this.printPanel.getLayerManager().setFiringEvents(false);
                int j = 0;
                for (Layerable layerable : this.printLayerables) {
                    if (!(layerable instanceof Layer)) continue;
                    Layer layer = (Layer)layerable;
                    layer.setStyles(oldStyleList.get(j++));
                }
                this.printPanel.getLayerManager().setFiringEvents(wasFiringEvents);
            }
            if (this.printPanel != null) {
                PrinterDriver.enableDoubleBuffering((Component)this.printPanel);
                this.printPanel.dispose();
                this.printPanel = null;
            }
            context.getWorkbenchFrame().setStatusMessage(this.FINISHED_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printCurrentWindow(PlugInContext context) throws PrinterException {
        this.pluginContext = context;
        Throwable[] throwable = new Throwable[]{null};
        this.printPanel = this.createLayerPanel(context.getLayerManager(), throwable);
        PrinterDriver.disableDoubleBuffering((Component)this.printPanel);
        this.windowEnvelope = this.pluginContext.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        this.fence = this.pluginContext.getLayerViewPanel().getFence();
        this.printLayerables = new ArrayList(context.getLayerManager().getLayerables(Layerable.class));
        Collections.reverse(this.printLayerables);
        PrinterDriver printerDriver = new PrinterDriver(context, this.printPanel);
        ScaleBarRenderer.setEnabled((boolean)ScaleBarRenderer.isEnabled((LayerViewPanel)context.getLayerViewPanel()), (LayerViewPanel)this.printPanel);
        NorthArrowRenderer.setEnabled((boolean)NorthArrowRenderer.isEnabled((LayerViewPanel)context.getLayerViewPanel()), (LayerViewPanel)this.printPanel);
        ShowScaleRenderer.setEnabled((boolean)ShowScaleRenderer.isEnabled((LayerViewPanel)context.getLayerViewPanel()), (LayerViewPanel)this.printPanel);
        printerDriver.setTaskFrame((TaskFrame)context.getWorkbenchFrame().getActiveInternalFrame());
        printerDriver.setPrintBorder(this.printBorder);
        ArrayList<Collection<Style>> oldStyleList = PrinterDriver.optimizeForVectors(this.printLayerables, this.removeThemeFills, this.removeBasicFills, this.changeLineWidth, this.lineWidthMultiplier, this.removeTransparency);
        printerDriver.setPrintLayerables(this.printLayerables);
        try {
            this.attributeSet.clear();
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (this.landscapeOrientation) {
                this.attributeSet.add(OrientationRequested.LANDSCAPE);
            } else {
                this.attributeSet.add(OrientationRequested.PORTRAIT);
            }
            if (this.mediaSizeNameObject instanceof MediaSizeName) {
                this.attributeSet.add((MediaSizeName)this.mediaSizeNameObject);
            }
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            if (this.printService == null) {
                PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, this.attributeSet);
                if (services.length > 0) {
                    this.printService = services[0];
                } else {
                    context.getWorkbenchFrame().warnUser(this.PRINTER_NOT_FOUND);
                    return;
                }
            }
            this.attributeSet.add(new JobName(context.getTask().getName(), null));
            printerJob.setPrintService(this.printService);
            if (printerJob.printDialog()) {
                PageFormat pageFormat = PrinterDriver.getPageFormat(this.attributeSet, printerJob);
                printerJob.setPrintable(printerDriver, pageFormat);
                try {
                    this.initLayerViewPanel(pageFormat);
                    printerDriver.setResolutionFactor(this.resolutionFactor);
                }
                catch (Exception e) {
                    String message = e.getMessage() == null ? e.toString() : e.getMessage();
                    System.err.println(message);
                    throw new PrinterException(message);
                }
                printerJob.print(this.attributeSet);
            }
            if (throwable[0] != null) {
                String message = throwable[0].getMessage() == null ? throwable[0].toString() : throwable[0].getMessage();
                System.err.println(message);
                context.getErrorHandler().handleThrowable(throwable[0] instanceof Exception ? throwable[0] : new Exception(message));
            }
            this.printService = printerJob.getPrintService();
        }
        finally {
            if (oldStyleList != null) {
                boolean wasFiringEvents = this.printPanel.getLayerManager().isFiringEvents();
                this.printPanel.getLayerManager().setFiringEvents(false);
                int j = 0;
                for (Layerable layerable : this.printLayerables) {
                    if (!(layerable instanceof Layer)) continue;
                    Layer layer = (Layer)layerable;
                    layer.setStyles(oldStyleList.get(j++));
                }
                this.printPanel.getLayerManager().setFiringEvents(wasFiringEvents);
            }
            if (this.printPanel != null) {
                PrinterDriver.enableDoubleBuffering((Component)this.printPanel);
                this.printPanel.dispose();
                this.printPanel = null;
            }
            printerDriver = null;
            context.getWorkbenchFrame().setStatusMessage(this.FINISHED_MESSAGE);
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance((WorkbenchContext)workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesMustExistCheck(1));
    }

    protected LayerViewPanel createLayerPanel(LayerManager layerManager, final Throwable[] throwable) {
        return new LayerViewPanel(layerManager, new LayerViewPanelContext(){

            public void setStatusMessage(String message) {
            }

            public void warnUser(String warning) {
            }

            public void handleThrowable(Throwable t) {
                throwable[0] = t;
            }
        });
    }

    protected Envelope computePrintPageEnvelope(Envelope windowEnvelope, PageFormat pf) {
        double pageRatio = pf.getImageableHeight() / pf.getImageableWidth();
        double minX = windowEnvelope.getMinX();
        double maxX = windowEnvelope.getMaxX();
        double minY = windowEnvelope.getMinY();
        double maxY = windowEnvelope.getMaxY();
        if (this.expandToFit) {
            minY = windowEnvelope.getMaxY() - windowEnvelope.getWidth() * pageRatio;
            maxY = windowEnvelope.getMaxY();
        }
        return new Envelope(minX, maxX, minY, maxY);
    }

    protected void initLayerViewPanel(PageFormat pageFormat) throws Exception {
        Envelope printEnvelope = this.printFenceArea && this.fence != null ? this.computePrintPageEnvelope(this.fence.getEnvelopeInternal(), pageFormat) : (this.printBoundsArea ? this.computePrintPageEnvelope(((Geometry)this.pluginContext.getLayerViewPanel().getSelectionManager().getSelectedItems().iterator().next()).getEnvelopeInternal(), pageFormat) : (this.scaleValue.equals(this.SCALE_MAXIMUM_VIEW) ? this.computePrintPageEnvelope(this.pluginContext.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates(), pageFormat) : (this.scaleValue.equals(this.SCALE_FULL_EXTENT) ? this.computePrintPageEnvelope(EnvelopeUtil.bufferByFraction((Envelope)this.pluginContext.getLayerManager().getEnvelopeOfAllLayers(true), (double)0.03), pageFormat) : this.computePrintPageEnvelope(this.windowEnvelope, pageFormat))));
        int extentInPixelsX = (int)(pageFormat.getImageableWidth() * (double)this.resolutionFactor);
        int extentInPixelsY = (int)(pageFormat.getImageableHeight() * (double)this.resolutionFactor);
        if (!this.expandToFit) {
            double ratio = printEnvelope.getHeight() / printEnvelope.getWidth();
            extentInPixelsY = (int)Math.round(ratio * pageFormat.getImageableWidth() * (double)this.resolutionFactor);
        }
        this.printPanel.setSize(extentInPixelsX, extentInPixelsY);
        double scale = 0.0;
        if (!(this.printFenceArea && this.fence != null || this.printBoundsArea || this.scaleValue.equals(this.SCALE_MAXIMUM_VIEW) || this.scaleValue.equals(this.SCALE_FULL_EXTENT))) {
            try {
                scale = Double.parseDouble(this.scaleValue.replaceFirst("^.*:", "").replaceAll("[^0-9]*", ""));
            }
            catch (NumberFormatException nfe) {
                scale = 0.0;
            }
        }
        if (scale > 0.0) {
            Envelope screenEnvelope = this.pluginContext.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
            double xCenter = screenEnvelope.getMinX() + screenEnvelope.getWidth() / 2.0;
            double yCenter = screenEnvelope.getMinY() + screenEnvelope.getHeight() / 2.0;
            double scaledEnvelopeWidth = (double)extentInPixelsX / 72.0 * 2.54 / 100.0 * scale;
            double scaledEnvelopeHeight = (double)extentInPixelsY / 72.0 * 2.54 / 100.0 * scale;
            Envelope scaledEnvelope = new Envelope(xCenter - scaledEnvelopeWidth / 2.0, xCenter + scaledEnvelopeWidth / 2.0, yCenter - scaledEnvelopeHeight / 2.0, yCenter + scaledEnvelopeHeight / 2.0);
            this.printPanel.getViewport().zoom(scaledEnvelope);
        } else {
            this.printPanel.getViewport().zoom(printEnvelope);
        }
    }
}

