package org.openjump.core.rasterimage.styler.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

import javax.swing.JOptionPane;

import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.ColorUtils;
import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.RasterStylesExtension;

import com.vividsolutions.jump.workbench.Logger;

/**
 *
 * @author GeomaticaEAmbiente
 */
public class SingleValuesPanel extends javax.swing.JPanel {

    /**
     * Creates new form SingleValuesPanel
     * @param parent parent component
     * @param rasterDataNoNull not null data values in this raster
     * @param rasterImageLayer raster image to symbolize
     */
    public SingleValuesPanel(Component parent, double[] rasterDataNoNull, RasterImageLayer rasterImageLayer) {

        initComponents();
        this.parent = parent;
        this.rasterDataNoNull = rasterDataNoNull;
        this.rasterImageLayer = rasterImageLayer;
        
        fixComponents();
        
    }

    public void reset() {
        try {
            findUniqueValues();
            rampAll(true);
        } catch (Exception ex) {
            Logger.error(ex);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel_Table = new javax.swing.JPanel();
        jButton_Ramp = new javax.swing.JButton();
        jButton_Random = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();

        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        java.awt.GridBagLayout layout = new java.awt.GridBagLayout();
        layout.columnWidths = new int[] {0, 5, 0, 5, 0};
        layout.rowHeights = new int[] {0, 5, 0, 5, 0, 5, 0};
        setLayout(layout);

        jPanel_Table.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        javax.swing.GroupLayout jPanel_TableLayout = new javax.swing.GroupLayout(jPanel_Table);
        jPanel_Table.setLayout(jPanel_TableLayout);
        jPanel_TableLayout.setHorizontalGroup(
            jPanel_TableLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 246, Short.MAX_VALUE)
        );
        jPanel_TableLayout.setVerticalGroup(
            jPanel_TableLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 166, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        add(jPanel_Table, gridBagConstraints);

        jButton_Ramp.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.SingleValuesPanel.jButton_RampAll")); // NOI18N
        jButton_Ramp.addActionListener(this::jButton_RampActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jButton_Ramp, gridBagConstraints);

        jButton_Random.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.SingleValuesPanel.jButton_Random")); // NOI18N
        jButton_Random.addActionListener(this::jButton_RandomActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jButton_Random, gridBagConstraints);

        jButton1.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.SingleValuesPanel.jButton_Ramp")); // NOI18N
        jButton1.addActionListener(this::jButton1ActionPerformed);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jButton1, gridBagConstraints);
    }

    private void jButton_RampActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_RampActionPerformed
        try {
            rampAll(false);
        } catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void jButton_RandomActionPerformed(java.awt.event.ActionEvent evt) {
        try {
            rampAll(true);
        } catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {

        if(firstTimeShown /*&& rasterImageLayer.getSymbology() == null*/) {
            firstTimeShown = false;
            try {
                findUniqueValues();
                rampAll(true);
            } catch (Exception ex) {
                Logger.error(ex);
            }
        }
        
    }

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {
        try {
            rampColors();
        } catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void fixComponents() {
       
        jComboBox_Gradient = GUIUtils.createStandardGradientComboBox(200, 18);
        
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jComboBox_Gradient, gridBagConstraints);
        
        GUIUtils.addGradientComboBoxToList(jComboBox_Gradient);
        
    }
    
    private void findUniqueValues() {
        
        Set<Double> uniqueValues_m = new TreeSet<Double>();
        integerValues = true;
        for(int v=0; v<rasterDataNoNull.length; v++) {
            uniqueValues_m.add(rasterDataNoNull[v]);
            if(rasterDataNoNull[v] != (int) rasterDataNoNull[v]) {
                integerValues = false;
            }
        }
        
        rasterDataNoNull = new double[uniqueValues_m.size()];
        Iterator iter = uniqueValues_m.iterator();
        int pos = 0;
        while(iter.hasNext()) {
            double value = (Double) iter.next();
            rasterDataNoNull[pos++] = value;
        }
        
    }
    
    private void rampAll(boolean randomColors) throws Exception {

        ColorUtils colorUtils = new ColorUtils();
        ColorMapEntry[] colorMapEntries = new ColorMapEntry[rasterDataNoNull.length];
        if(randomColors) {
            /* Calculate colors */
            for(int c=0; c<rasterDataNoNull.length; c++) {
                colorMapEntries[c] = new ColorMapEntry(rasterDataNoNull[c],
                        colorUtils.randomColor());
            } 
        } else {
        
            ColorMapEntry[] paletteColorMapEntries = ((GradientCanvas) jComboBox_Gradient.getSelectedItem()).getColorMapEntries();
            int colorsCount = paletteColorMapEntries.length;
            
            /* Calculate colors */
            for(int c=0; c<rasterDataNoNull.length; c++) {
                
                double cellRelDistance = (double) c / (double) (rasterDataNoNull.length-1);
                double colorRelDistance = cellRelDistance * (colorsCount - 1);
                
                Color startColor = paletteColorMapEntries[(int) Math.floor(colorRelDistance)].getColor();
                Color endColor = paletteColorMapEntries[(int) Math.ceil(colorRelDistance)].getColor();
                
                Color color = colorUtils.interpolateColor(startColor, endColor, cellRelDistance);
                colorMapEntries[c] = new ColorMapEntry(rasterDataNoNull[c], color);
            }        
        
        }
        
        updateTable(colorMapEntries);
        
    }
    
    private void rampColors() throws Exception {
        if(colorsTablePanel.getSelectedRowsCount() != 2) {
            JOptionPane.showMessageDialog(
                    this,
                    I18N.get("org.openjump.core.rasterimage.styler.ui.SingleValuesPanel.message.SelectTwoRows"),
                    RasterStylesExtension.extensionName,
                    JOptionPane.WARNING_MESSAGE);
        }
        colorsTablePanel.rampColors();
    }
    
    public RasterSymbology getRasterStyler() throws Exception{
        
        RasterSymbology rasterSymbolizer = new RasterSymbology(RasterSymbology.TYPE_SINGLE);
        for (ColorMapEntry colorMapEntry : colorsTablePanel.getColorMapEntries()) {
            rasterSymbolizer.addColorMapEntry(colorMapEntry.getUpperValue(), colorMapEntry.getColor());
        }
        
        return rasterSymbolizer;
    }
    
    public void plugRasterSymbology(RasterSymbology rasterSymbology) {
        
        updateTable(rasterSymbology.getColorMapEntries());
        
    }
    
    private void updateTable(ColorMapEntry[] colorMapEntries) {
        /* Update table */
        if(colorsTablePanel == null) {
            colorsTablePanel = new ColorsTablePanel(parent, ColorsTablePanel.TableType.VALUES,
                    colorMapEntries, rasterImageLayer.getNoDataValue(), integerValues);
            GridBagLayout layout = (GridBagLayout)getLayout();
            GridBagConstraints gbc = layout.getConstraints(jPanel_Table);
            remove(jPanel_Table);
            add(colorsTablePanel, gbc);
            validate();
        } else {
            colorsTablePanel.updateTable(colorMapEntries);
        }
    }
    
    private final Component parent;
    private double[] rasterDataNoNull;
    private final RasterImageLayer rasterImageLayer;
    private ColorsTablePanel colorsTablePanel = null;
    private GradientComboBox jComboBox_Gradient;
    private boolean integerValues;
    private boolean firstTimeShown = true;
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton_Ramp;
    private javax.swing.JButton jButton_Random;
    private javax.swing.JPanel jPanel_Table;
    // End of variables declaration//GEN-END:variables

    public GradientComboBox getGradientComboBox(){
        return jComboBox_Gradient;
    }
    
}
