/*
 * Decompiled with CFR 0.152.
 */
package buoy.xml.delegate;

import buoy.internal.EventLinkRecord;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Statement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class EventSourceDelegate
extends DefaultPersistenceDelegate {
    public EventSourceDelegate() {
    }

    public EventSourceDelegate(String[] constructorPropertyNames) {
        super(constructorPropertyNames);
    }

    protected void initialize(Class type, Object oldInstance, Object newInstance, Encoder out) {
        super.initialize(type, oldInstance, newInstance, out);
        this.initializeEventLinks(oldInstance, newInstance, out);
    }

    protected void initializeEventLinks(Object oldInstance, Object newInstance, Encoder out) {
        ArrayList oldLinks = (ArrayList)EventSourceDelegate.getField(newInstance, "eventLinks");
        ArrayList newLinks = (ArrayList)EventSourceDelegate.getField(oldInstance, "eventLinks");
        if (newLinks == null) {
            return;
        }
        for (int i = 0; i < newLinks.size(); ++i) {
            EventLinkRecord rec = (EventLinkRecord)newLinks.get(i);
            ArrayList targetList = (ArrayList)EventSourceDelegate.getField(rec, "targetList");
            ArrayList methodList = (ArrayList)EventSourceDelegate.getField(rec, "targetMethodList");
            if (targetList == null || methodList == null) continue;
            for (int j = 0; j < targetList.size(); ++j) {
                Method method = (Method)methodList.get(j);
                if (this.alreadyHasLink(oldLinks, rec.getEventType(), out.get(targetList.get(j)), method)) continue;
                out.writeStatement(new Statement(oldInstance, "addEventLink", new Object[]{rec.getEventType(), targetList.get(j), method.getName()}));
            }
        }
    }

    private boolean alreadyHasLink(ArrayList oldLinks, Class eventType, Object target, Method method) {
        if (oldLinks == null) {
            return false;
        }
        for (int i = 0; i < oldLinks.size(); ++i) {
            EventLinkRecord rec = (EventLinkRecord)oldLinks.get(i);
            if (rec.getEventType() != eventType) continue;
            ArrayList targetList = (ArrayList)EventSourceDelegate.getField(rec, "targetList");
            ArrayList methodList = (ArrayList)EventSourceDelegate.getField(rec, "targetMethodList");
            if (targetList == null || methodList == null) continue;
            for (int j = 0; j < targetList.size(); ++j) {
                if (targetList.get(j) != target || !methodList.get(j).equals(method)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Object getField(Object obj, String field) {
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            try {
                Field f = cls.getDeclaredField(field);
                f.setAccessible(true);
                return f.get(obj);
            }
            catch (Exception ex) {
                continue;
            }
        }
        return null;
    }
}

