/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.jpeg.JpegConstants;
import org.apache.commons.imaging.formats.jpeg.segments.AbstractSegment;

public class JfifSegment
extends AbstractSegment {
    public final int jfifMajorVersion;
    public final int jfifMinorVersion;
    public final int densityUnits;
    public final int xDensity;
    public final int yDensity;
    public final int xThumbnail;
    public final int yThumbnail;
    public final int thumbnailSize;

    public JfifSegment(int marker, byte[] segmentData) throws ImagingException, IOException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public JfifSegment(int marker, int markerLength, InputStream is) throws ImagingException, IOException {
        super(marker, markerLength);
        byte[] signature = BinaryFunctions.readBytes(is, JpegConstants.JFIF0_SIGNATURE.size());
        if (!JpegConstants.JFIF0_SIGNATURE.equals(signature) && !JpegConstants.JFIF0_SIGNATURE_ALTERNATIVE.equals(signature)) {
            throw new ImagingException("Not a Valid JPEG File: missing JFIF string");
        }
        this.jfifMajorVersion = BinaryFunctions.readByte("jfifMajorVersion", is, "Not a Valid JPEG File");
        this.jfifMinorVersion = BinaryFunctions.readByte("jfifMinorVersion", is, "Not a Valid JPEG File");
        this.densityUnits = BinaryFunctions.readByte("densityUnits", is, "Not a Valid JPEG File");
        this.xDensity = BinaryFunctions.read2Bytes("xDensity", is, "Not a Valid JPEG File", this.getByteOrder());
        this.yDensity = BinaryFunctions.read2Bytes("yDensity", is, "Not a Valid JPEG File", this.getByteOrder());
        this.xThumbnail = BinaryFunctions.readByte("xThumbnail", is, "Not a Valid JPEG File");
        this.yThumbnail = BinaryFunctions.readByte("yThumbnail", is, "Not a Valid JPEG File");
        this.thumbnailSize = this.xThumbnail * this.yThumbnail;
        if (this.thumbnailSize > 0) {
            BinaryFunctions.skipBytes(is, this.thumbnailSize, "Not a Valid JPEG File: missing thumbnail");
        }
    }

    @Override
    public String getDescription() {
        return "JFIF (" + this.getSegmentType() + ")";
    }
}

