/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class HistogramPlot2D
extends Plot {
    double[][] topLeft;
    double[][] topRight;
    double[][] bottomLeft;
    double[][] bottomRight;
    double[] widths;
    double width_constant = -1.0;
    double offsetCenter_perWidth;
    double factorWidth;
    boolean autowidth;
    boolean fill_shape = true;
    double[][] XY;

    public HistogramPlot2D(String n, Color c, double[][] _XY, double w) {
        this(n, c, _XY, w, 0.5, 1.0);
    }

    public HistogramPlot2D(String n, Color c, double[][] _XY, double[] w) {
        this(n, c, _XY, w, 0.5, 1.0);
    }

    public HistogramPlot2D(String n, Color c, double[][] _XY, double w, double _offsetCenter_perWidth, double _factorWidth) {
        super(n, c);
        this.XY = _XY;
        this.width_constant = w;
        this.autowidth = false;
        this.offsetCenter_perWidth = _offsetCenter_perWidth;
        this.factorWidth = _factorWidth;
        this.build();
    }

    public HistogramPlot2D(String n, Color c, double[][] _XY, double[] w, double _offsetCenter_perWidth, double _factorWidth) {
        super(n, c);
        this.XY = _XY;
        this.widths = w;
        this.autowidth = false;
        this.offsetCenter_perWidth = _offsetCenter_perWidth;
        this.factorWidth = _factorWidth;
        this.build();
    }

    private void build() {
        if (this.width_constant > 0.0) {
            this.topLeft = new double[this.XY.length][];
            this.topRight = new double[this.XY.length][];
            this.bottomLeft = new double[this.XY.length][];
            this.bottomRight = new double[this.XY.length][];
            for (int i = 0; i < this.XY.length; ++i) {
                this.topLeft[i] = new double[]{this.XY[i][0] - this.factorWidth * this.width_constant / 2.0 + (this.offsetCenter_perWidth - 0.5) * this.width_constant, this.XY[i][1]};
                this.topRight[i] = new double[]{this.XY[i][0] + this.factorWidth * this.width_constant / 2.0 + (this.offsetCenter_perWidth - 0.5) * this.width_constant, this.XY[i][1]};
                this.bottomLeft[i] = new double[]{this.XY[i][0] - this.factorWidth * this.width_constant / 2.0 + (this.offsetCenter_perWidth - 0.5) * this.width_constant, 0.0};
                this.bottomRight[i] = new double[]{this.XY[i][0] + this.factorWidth * this.width_constant / 2.0 + (this.offsetCenter_perWidth - 0.5) * this.width_constant, 0.0};
            }
        } else {
            this.topLeft = new double[this.XY.length][];
            this.topRight = new double[this.XY.length][];
            this.bottomLeft = new double[this.XY.length][];
            this.bottomRight = new double[this.XY.length][];
            for (int i = 0; i < this.XY.length; ++i) {
                this.topLeft[i] = new double[]{this.XY[i][0] - this.factorWidth * this.widths[i] / 2.0 + (this.offsetCenter_perWidth - 0.5) * this.widths[i], this.XY[i][1]};
                this.topRight[i] = new double[]{this.XY[i][0] + this.factorWidth * this.widths[i] / 2.0 + (this.offsetCenter_perWidth - 0.5) * this.widths[i], this.XY[i][1]};
                this.bottomLeft[i] = new double[]{this.XY[i][0] - this.factorWidth * this.widths[i] / 2.0 + (this.offsetCenter_perWidth - 0.5) * this.widths[i], 0.0};
                this.bottomRight[i] = new double[]{this.XY[i][0] + this.factorWidth * this.widths[i] / 2.0 + (this.offsetCenter_perWidth - 0.5) * this.widths[i], 0.0};
            }
        }
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.visible) {
            return;
        }
        draw.setColor(c);
        draw.setLineType(1);
        for (int i = 0; i < this.XY.length; ++i) {
            draw.drawLine(this.bottomLeft[i], this.topLeft[i]);
            draw.drawLine(this.topLeft[i], this.topRight[i]);
            draw.drawLine(this.topRight[i], this.bottomRight[i]);
            draw.drawLine(this.bottomRight[i], this.bottomLeft[i]);
            if (!this.fill_shape) continue;
            draw.fillPolygon(0.2f, this.bottomLeft[i], this.topLeft[i], this.topRight[i], this.bottomRight[i]);
        }
    }

    @Override
    public void setData(double[][] d) {
        this.datapanel = null;
        this.XY = d;
    }

    @Override
    public double[][] getData() {
        return this.XY;
    }

    @Override
    public double[][] getBounds() {
        return new double[][]{Array.min(this.bottomLeft), Array.max(this.topRight)};
    }

    public void setDataWidth(double[] w) {
        this.widths = w;
        this.width_constant = -1.0;
        this.build();
    }

    public void setDataWidth(double w) {
        this.width_constant = w;
        this.build();
    }

    public double[] getDataWidth() {
        if (this.width_constant > 0.0) {
            this.widths = new double[this.XY.length];
            for (int i = 0; i < this.widths.length; ++i) {
                this.widths[i] = this.width_constant;
            }
        }
        return this.widths;
    }

    public void setData(double[][] d, double[] w) {
        this.setData(d);
        this.setDataWidth(w);
    }

    public void setData(double[][] d, double w) {
        this.setData(d);
        this.setDataWidth(w);
    }

    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        for (int i = 0; i < this.XY.length; ++i) {
            int[] screenCoord = draw.project(this.XY[i]);
            if (screenCoord[0] + this.note_precision <= screenCoordTest[0] || screenCoord[0] - this.note_precision >= screenCoordTest[0] || screenCoord[1] + this.note_precision <= screenCoordTest[1] || screenCoord[1] - this.note_precision >= screenCoordTest[1]) continue;
            return this.XY[i];
        }
        return null;
    }

    public static void main(String[] args) {
        double[] X = new double[500];
        for (int i = 0; i < X.length; ++i) {
            X[i] = Math.random() + Math.random();
        }
        Plot2DPanel p = new Plot2DPanel("SOUTH");
        p.addHistogramPlot("test", X, 10);
        new FrameView(p);
    }
}

