/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.python.core.BuiltinFunctions;
import org.python.core.CompilerFlags;
import org.python.core.ImportFunction;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyCallIter;
import org.python.core.PyClassMethod;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyDictionary;
import org.python.core.PyEnumerate;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyProperty;
import org.python.core.PySlice;
import org.python.core.PyStaticMethod;
import org.python.core.PyString;
import org.python.core.PyStringDerived;
import org.python.core.PyStringMap;
import org.python.core.PySuper;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.PyXRange;
import org.python.core.imp;

public class __builtin__ {
    private static PyStringMap internedStrings;
    public static PyString __doc__zip;

    public static void fillWithBuiltins(PyObject pyObject) {
        pyObject.__setitem__("object", (PyObject)PyType.fromClass(PyObject.class));
        pyObject.__setitem__("type", (PyObject)PyType.fromClass(PyType.class));
        pyObject.__setitem__("int", (PyObject)PyType.fromClass(PyInteger.class));
        pyObject.__setitem__("enumerate", (PyObject)PyType.fromClass(PyEnumerate.class));
        pyObject.__setitem__("float", (PyObject)PyType.fromClass(PyFloat.class));
        pyObject.__setitem__("long", (PyObject)PyType.fromClass(PyLong.class));
        pyObject.__setitem__("complex", (PyObject)PyType.fromClass(PyComplex.class));
        pyObject.__setitem__("dict", (PyObject)PyType.fromClass(PyDictionary.class));
        pyObject.__setitem__("list", (PyObject)PyType.fromClass(PyList.class));
        pyObject.__setitem__("tuple", (PyObject)PyType.fromClass(PyTuple.class));
        pyObject.__setitem__("property", (PyObject)PyType.fromClass(PyProperty.class));
        pyObject.__setitem__("staticmethod", (PyObject)PyType.fromClass(PyStaticMethod.class));
        pyObject.__setitem__("classmethod", (PyObject)PyType.fromClass(PyClassMethod.class));
        pyObject.__setitem__("super", (PyObject)PyType.fromClass(PySuper.class));
        pyObject.__setitem__("str", (PyObject)PyType.fromClass(PyString.class));
        pyObject.__setitem__("unicode", (PyObject)PyType.fromClass(PyUnicode.class));
        pyObject.__setitem__("basestring", (PyObject)PyType.fromClass(PyBaseString.class));
        pyObject.__setitem__("file", (PyObject)PyType.fromClass(PyFile.class));
        pyObject.__setitem__("open", (PyObject)PyType.fromClass(PyFile.class));
        pyObject.__setitem__("None", Py.None);
        pyObject.__setitem__("NotImplemented", Py.NotImplemented);
        pyObject.__setitem__("Ellipsis", Py.Ellipsis);
        pyObject.__setitem__("True", (PyObject)Py.One);
        pyObject.__setitem__("False", (PyObject)Py.Zero);
        pyObject.__setitem__("__debug__", (PyObject)Py.One);
        pyObject.__setitem__("abs", (PyObject)new BuiltinFunctions("abs", 7, 1));
        pyObject.__setitem__("apply", (PyObject)new BuiltinFunctions("apply", 9, 2, 3));
        pyObject.__setitem__("bool", (PyObject)new BuiltinFunctions("bool", 8, 1));
        pyObject.__setitem__("callable", (PyObject)new BuiltinFunctions("callable", 14, 1));
        pyObject.__setitem__("coerce", (PyObject)new BuiltinFunctions("coerce", 13, 2));
        pyObject.__setitem__("chr", (PyObject)new BuiltinFunctions("chr", 0, 1));
        pyObject.__setitem__("cmp", (PyObject)new BuiltinFunctions("cmp", 6, 2));
        pyObject.__setitem__("globals", (PyObject)new BuiltinFunctions("globals", 4, 0));
        pyObject.__setitem__("hash", (PyObject)new BuiltinFunctions("hash", 5, 1));
        pyObject.__setitem__("id", (PyObject)new BuiltinFunctions("id", 11, 1));
        pyObject.__setitem__("isinstance", (PyObject)new BuiltinFunctions("isinstance", 10, 2));
        pyObject.__setitem__("len", (PyObject)new BuiltinFunctions("len", 1, 1));
        pyObject.__setitem__("ord", (PyObject)new BuiltinFunctions("ord", 3, 1));
        pyObject.__setitem__("range", (PyObject)new BuiltinFunctions("range", 2, 1, 3));
        pyObject.__setitem__("sum", (PyObject)new BuiltinFunctions("sum", 12, 1, 2));
        pyObject.__setitem__("unichr", (PyObject)new BuiltinFunctions("unichr", 6, 1));
        pyObject.__setitem__("compile", (PyObject)new BuiltinFunctions("compile", 44, 3, -1));
        pyObject.__setitem__("delattr", (PyObject)new BuiltinFunctions("delattr", 15, 2));
        pyObject.__setitem__("dir", (PyObject)new BuiltinFunctions("dir", 16, 0, 1));
        pyObject.__setitem__("divmod", (PyObject)new BuiltinFunctions("divmod", 17, 2));
        pyObject.__setitem__("eval", (PyObject)new BuiltinFunctions("eval", 18, 1, 3));
        pyObject.__setitem__("execfile", (PyObject)new BuiltinFunctions("execfile", 19, 1, 3));
        pyObject.__setitem__("filter", (PyObject)new BuiltinFunctions("filter", 20, 2));
        pyObject.__setitem__("getattr", (PyObject)new BuiltinFunctions("getattr", 21, 2, 3));
        pyObject.__setitem__("hasattr", (PyObject)new BuiltinFunctions("hasattr", 22, 2));
        pyObject.__setitem__("hex", (PyObject)new BuiltinFunctions("hex", 23, 1));
        pyObject.__setitem__("input", (PyObject)new BuiltinFunctions("input", 24, 0, 1));
        pyObject.__setitem__("intern", (PyObject)new BuiltinFunctions("intern", 25, 1));
        pyObject.__setitem__("issubclass", (PyObject)new BuiltinFunctions("issubclass", 26, 2));
        pyObject.__setitem__("iter", (PyObject)new BuiltinFunctions("iter", 27, 1, 2));
        pyObject.__setitem__("locals", (PyObject)new BuiltinFunctions("locals", 28, 0));
        pyObject.__setitem__("map", (PyObject)new BuiltinFunctions("map", 29, 2, -1));
        pyObject.__setitem__("max", (PyObject)new BuiltinFunctions("max", 30, 1, -1));
        pyObject.__setitem__("min", (PyObject)new BuiltinFunctions("min", 31, 1, -1));
        pyObject.__setitem__("oct", (PyObject)new BuiltinFunctions("oct", 32, 1));
        pyObject.__setitem__("pow", (PyObject)new BuiltinFunctions("pow", 33, 2, 3));
        pyObject.__setitem__("raw_input", (PyObject)new BuiltinFunctions("raw_input", 34, 0, 1));
        pyObject.__setitem__("reduce", (PyObject)new BuiltinFunctions("reduce", 35, 2, 3));
        pyObject.__setitem__("reload", (PyObject)new BuiltinFunctions("reload", 36, 1));
        pyObject.__setitem__("repr", (PyObject)new BuiltinFunctions("repr", 37, 1));
        pyObject.__setitem__("round", (PyObject)new BuiltinFunctions("round", 38, 1, 2));
        pyObject.__setitem__("setattr", (PyObject)new BuiltinFunctions("setattr", 39, 3));
        pyObject.__setitem__("slice", (PyObject)new BuiltinFunctions("slice", 40, 1, 3));
        pyObject.__setitem__("vars", (PyObject)new BuiltinFunctions("vars", 41, 0, 1));
        pyObject.__setitem__("xrange", (PyObject)new BuiltinFunctions("xrange", 42, 1, 3));
        pyObject.__setitem__("zip", (PyObject)new BuiltinFunctions("zip", 43, 1, -1));
        pyObject.__setitem__("__import__", (PyObject)new ImportFunction());
    }

    public static PyObject abs(PyObject pyObject) {
        if (pyObject.isNumberType()) {
            return pyObject.__abs__();
        }
        throw Py.TypeError("bad operand type for abs()");
    }

    public static PyObject apply(PyObject pyObject, PyObject pyObject2) {
        return pyObject.__call__(Py.make_array(pyObject2));
    }

    public static PyObject apply(PyObject pyObject, PyObject pyObject2, PyDictionary pyDictionary) {
        Hashtable hashtable = pyDictionary.table;
        if (hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            Enumeration enumeration2 = hashtable.elements();
            int n = hashtable.size();
            String[] stringArray = new String[n];
            PyObject[] pyObjectArray = Py.make_array(pyObject2);
            PyObject[] pyObjectArray2 = new PyObject[n + pyObjectArray.length];
            System.arraycopy(pyObjectArray, 0, pyObjectArray2, 0, pyObjectArray.length);
            int n2 = pyObjectArray.length;
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((PyString)enumeration.nextElement()).internedString();
                pyObjectArray2[i + n2] = (PyObject)enumeration2.nextElement();
            }
            return pyObject.__call__(pyObjectArray2, stringArray);
        }
        return __builtin__.apply(pyObject, pyObject2);
    }

    public static PyObject bool(PyObject pyObject) {
        return pyObject == null ? Py.Zero : (pyObject.__nonzero__() ? Py.One : Py.Zero);
    }

    public static boolean callable(PyObject pyObject) {
        return pyObject.__findattr__("__call__") != null;
    }

    public static char unichr(int n) {
        return __builtin__.chr(n);
    }

    public static char chr(int n) {
        if (n < 0 || n > 65535) {
            throw Py.ValueError("chr() arg not in range(65535)");
        }
        return (char)n;
    }

    public static int cmp(PyObject pyObject, PyObject pyObject2) {
        return pyObject._cmp(pyObject2);
    }

    public static PyTuple coerce(PyObject pyObject, PyObject pyObject2) {
        PyObject[] pyObjectArray = pyObject._coerce(pyObject2);
        if (pyObjectArray != null) {
            return new PyTuple(pyObjectArray);
        }
        throw Py.TypeError("number coercion failed");
    }

    public static PyCode compile(String string, String string2, String string3) {
        return Py.compile_flags(string, string2, string3, Py.getCompilerFlags());
    }

    public static PyCode compile(String string, String string2, String string3, int n, boolean bl) {
        if ((n & 0xFFFFCFEF) != 0) {
            throw Py.ValueError("compile(): unrecognised flags");
        }
        return Py.compile_flags(string, string2, string3, Py.getCompilerFlags(n, bl));
    }

    public static void delattr(PyObject pyObject, String string) {
        pyObject.__delattr__(string);
    }

    public static PyObject dir(PyObject pyObject) {
        PyList pyList = (PyList)pyObject.__dir__();
        pyList.sort();
        return pyList;
    }

    public static PyObject dir() {
        PyList pyList;
        PyObject pyObject = __builtin__.locals();
        if (pyObject instanceof PyStringMap) {
            pyList = ((PyStringMap)pyObject).keys();
        } else if (pyObject instanceof PyDictionary) {
            pyList = ((PyDictionary)pyObject).keys();
        }
        pyList = (PyList)pyObject.invoke("keys");
        pyList.sort();
        return pyList;
    }

    public static PyObject divmod(PyObject pyObject, PyObject pyObject2) {
        return pyObject._divmod(pyObject2);
    }

    public static PyEnumerate enumerate(PyObject pyObject) {
        return new PyEnumerate(pyObject);
    }

    public static PyObject eval(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        PyCode pyCode;
        if (pyObject instanceof PyCode) {
            pyCode = (PyCode)pyObject;
        } else if (pyObject instanceof PyString) {
            pyCode = __builtin__.compile(pyObject.toString(), "<string>", "eval");
        } else {
            throw Py.TypeError("eval: argument 1 must be string or code object");
        }
        return Py.runCode(pyCode, pyObject3, pyObject2);
    }

    public static PyObject eval(PyObject pyObject, PyObject pyObject2) {
        return __builtin__.eval(pyObject, pyObject2, pyObject2);
    }

    public static PyObject eval(PyObject pyObject) {
        if (pyObject instanceof PyTableCode && ((PyTableCode)pyObject).hasFreevars()) {
            throw Py.TypeError("code object passed to eval() may not contain free variables");
        }
        return __builtin__.eval(pyObject, null, null);
    }

    public static void execfile(String string, PyObject pyObject, PyObject pyObject2) {
        __builtin__.execfile_flags(string, pyObject, pyObject2, Py.getCompilerFlags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execfile_flags(String string, PyObject pyObject, PyObject pyObject2, CompilerFlags compilerFlags) {
        PyCode pyCode;
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw Py.IOError(fileNotFoundException);
        }
        try {
            pyCode = Py.compile_flags(fileInputStream, string, "exec", compilerFlags);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw Py.IOError(iOException);
            }
        }
        Py.runCode(pyCode, pyObject2, pyObject);
    }

    public static void execfile(String string, PyObject pyObject) {
        __builtin__.execfile(string, pyObject, pyObject);
    }

    public static void execfile(String string) {
        __builtin__.execfile(string, null, null);
    }

    public static PyObject filter(PyObject pyObject, PyString pyString) {
        if (pyObject == Py.None) {
            return pyString;
        }
        PyObject[] pyObjectArray = new PyObject[1];
        char[] cArray = pyString.toString().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            pyObjectArray[0] = Py.makeCharacter(cArray[i]);
            if (!pyObject.__call__(pyObjectArray).__nonzero__()) continue;
            cArray[n2++] = cArray[i];
        }
        return new PyString(new String(cArray, 0, n2));
    }

    public static PyObject filter(PyObject pyObject, PyObject pyObject2) {
        if (pyObject2 instanceof PyString) {
            return __builtin__.filter(pyObject, (PyString)pyObject2);
        }
        PyList pyList = new PyList();
        PyObject pyObject3 = pyObject2.__iter__();
        PyObject pyObject4 = null;
        while ((pyObject4 = pyObject3.__iternext__()) != null) {
            if (pyObject == Py.None ? !pyObject4.__nonzero__() : !pyObject.__call__(pyObject4).__nonzero__()) continue;
            pyList.append(pyObject4);
        }
        if (pyObject2 instanceof PyTuple) {
            return __builtin__.tuple(pyList);
        }
        return pyList;
    }

    public static PyObject getattr(PyObject pyObject, String string) {
        return pyObject.__getattr__(string);
    }

    public static PyObject getattr(PyObject pyObject, String string, PyObject pyObject2) {
        PyObject pyObject3 = pyObject.__findattr__(string);
        if (pyObject3 != null) {
            return pyObject3;
        }
        return pyObject2;
    }

    public static PyObject globals() {
        return Py.getFrame().f_globals;
    }

    public static boolean hasattr(PyObject pyObject, String string) {
        try {
            return pyObject.__findattr__(string) != null;
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.AttributeError)) {
                return false;
            }
            throw pyException;
        }
    }

    public static PyInteger hash(PyObject pyObject) {
        return pyObject.__hash__();
    }

    public static PyString hex(PyObject pyObject) {
        try {
            return pyObject.__hex__();
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.AttributeError)) {
                throw Py.TypeError("hex() argument can't be converted to hex");
            }
            throw pyException;
        }
    }

    public static long id(PyObject pyObject) {
        return Py.id(pyObject);
    }

    public static PyObject input(PyObject pyObject) {
        String string = __builtin__.raw_input(pyObject);
        return __builtin__.eval(new PyString(string));
    }

    public static PyObject input() {
        return __builtin__.input(new PyString(""));
    }

    public static PyString intern(PyString pyString) {
        String string;
        PyObject pyObject;
        if (internedStrings == null) {
            internedStrings = new PyStringMap();
        }
        if ((pyObject = internedStrings.__finditem__(string = pyString.internedString())) != null) {
            return (PyString)pyObject;
        }
        if (pyString instanceof PyStringDerived) {
            pyString = pyString.__str__();
        }
        internedStrings.__setitem__(string, (PyObject)pyString);
        return pyString;
    }

    public static boolean isinstance(PyObject pyObject, PyObject pyObject2) {
        return Py.isInstance(pyObject, pyObject2);
    }

    public static boolean issubclass(PyObject pyObject, PyObject pyObject2) {
        return Py.isSubClass(pyObject, pyObject2);
    }

    public static PyObject iter(PyObject pyObject) {
        return pyObject.__iter__();
    }

    public static PyObject iter(PyObject pyObject, PyObject pyObject2) {
        return new PyCallIter(pyObject, pyObject2);
    }

    public static int len(PyObject pyObject) {
        try {
            return pyObject.__len__();
        }
        catch (PyException pyException) {
            if (pyException.type == Py.AttributeError && !(pyObject instanceof PyInstance)) {
                throw Py.TypeError("len() of unsized object");
            }
            throw pyException;
        }
    }

    public static PyObject locals() {
        return Py.getFrame().getf_locals();
    }

    public static PyObject map(PyObject[] pyObjectArray) {
        int n;
        int n2 = pyObjectArray.length - 1;
        if (n2 < 1) {
            throw Py.TypeError("map requires at least two arguments");
        }
        PyObject pyObject = pyObjectArray[0];
        PyList pyList = new PyList();
        PyObject[] pyObjectArray2 = new PyObject[n2];
        PyObject[] pyObjectArray3 = new PyObject[n2];
        for (n = 0; n < n2; ++n) {
            pyObjectArray3[n] = Py.iter(pyObjectArray[n + 1], "argument " + (n + 1) + " to map() must support iteration");
        }
        while (true) {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                PyObject pyObject2 = pyObjectArray3[i].__iternext__();
                if (pyObject2 != null) {
                    pyObjectArray2[i] = pyObject2;
                    n = 1;
                    continue;
                }
                pyObjectArray2[i] = Py.None;
            }
            if (n == 0) break;
            if (pyObject == Py.None) {
                if (n2 == 1) {
                    pyList.append(pyObjectArray2[0]);
                    continue;
                }
                pyList.append(new PyTuple((PyObject[])pyObjectArray2.clone()));
                continue;
            }
            pyList.append(pyObject.__call__(pyObjectArray2));
        }
        return pyList;
    }

    public static PyObject max(PyObject[] pyObjectArray) {
        if (pyObjectArray.length == 1) {
            return __builtin__.max(pyObjectArray[0]);
        }
        return __builtin__.max(new PyTuple(pyObjectArray));
    }

    private static PyObject max(PyObject pyObject) {
        PyObject pyObject2;
        PyObject pyObject3 = null;
        PyObject pyObject4 = pyObject.__iter__();
        while ((pyObject2 = pyObject4.__iternext__()) != null) {
            if (pyObject3 != null && !pyObject2._gt(pyObject3).__nonzero__()) continue;
            pyObject3 = pyObject2;
        }
        if (pyObject3 == null) {
            throw Py.ValueError("max of empty sequence");
        }
        return pyObject3;
    }

    public static PyObject min(PyObject[] pyObjectArray) {
        if (pyObjectArray.length == 1) {
            return __builtin__.min(pyObjectArray[0]);
        }
        return __builtin__.min(new PyTuple(pyObjectArray));
    }

    private static PyObject min(PyObject pyObject) {
        PyObject pyObject2;
        PyObject pyObject3 = null;
        PyObject pyObject4 = pyObject.__iter__();
        while ((pyObject2 = pyObject4.__iternext__()) != null) {
            if (pyObject3 != null && !pyObject2._lt(pyObject3).__nonzero__()) continue;
            pyObject3 = pyObject2;
        }
        if (pyObject3 == null) {
            throw Py.ValueError("min of empty sequence");
        }
        return pyObject3;
    }

    public static PyString oct(PyObject pyObject) {
        return pyObject.__oct__();
    }

    public static final int ord(char c) {
        return c;
    }

    public static PyObject pow(PyObject pyObject, PyObject pyObject2) {
        return pyObject._pow(pyObject2);
    }

    private static boolean coerce(PyObject[] pyObjectArray) {
        PyObject pyObject = pyObjectArray[0];
        PyObject pyObject2 = pyObjectArray[1];
        PyObject[] pyObjectArray2 = pyObject._coerce(pyObject2);
        if (pyObjectArray2 != null) {
            pyObjectArray[0] = pyObjectArray2[0];
            pyObjectArray[1] = pyObjectArray2[1];
            return true;
        }
        pyObjectArray2 = pyObject2._coerce(pyObject);
        if (pyObjectArray2 != null) {
            pyObjectArray[0] = pyObjectArray2[1];
            pyObjectArray[1] = pyObjectArray2[0];
            return true;
        }
        return false;
    }

    public static PyObject pow(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        PyObject pyObject4 = pyObject;
        PyObject pyObject5 = pyObject2;
        PyObject pyObject6 = pyObject3;
        PyObject[] pyObjectArray = new PyObject[]{pyObject4, pyObject5};
        if (__builtin__.coerce(pyObjectArray)) {
            pyObject4 = pyObjectArray[0];
            pyObject5 = pyObjectArray[1];
            pyObjectArray[1] = pyObject6;
            if (__builtin__.coerce(pyObjectArray)) {
                pyObject4 = pyObjectArray[0];
                pyObject6 = pyObjectArray[1];
                pyObjectArray[0] = pyObject5;
                if (__builtin__.coerce(pyObjectArray)) {
                    pyObject6 = pyObjectArray[1];
                    pyObject5 = pyObjectArray[0];
                }
            }
        } else {
            pyObjectArray[1] = pyObject6;
            if (__builtin__.coerce(pyObjectArray)) {
                pyObject4 = pyObjectArray[0];
                pyObject6 = pyObjectArray[1];
                pyObjectArray[0] = pyObject5;
                if (__builtin__.coerce(pyObjectArray)) {
                    pyObject5 = pyObjectArray[0];
                    pyObject6 = pyObjectArray[1];
                    pyObjectArray[1] = pyObject4;
                    if (__builtin__.coerce(pyObjectArray)) {
                        pyObject4 = pyObjectArray[1];
                        pyObject5 = pyObjectArray[0];
                    }
                }
            }
        }
        if (pyObject4.getType() == pyObject5.getType() && pyObject4.getType() == pyObject6.getType() && (pyObject4 = pyObject4.__pow__(pyObject5, pyObject6)) != null) {
            return pyObject4;
        }
        throw Py.TypeError("__pow__ not defined for these operands");
    }

    public static PyObject range(int n, int n2, int n3) {
        if (n3 == 0) {
            throw Py.ValueError("zero step for range()");
        }
        int n4 = n3 > 0 ? (n2 - n + n3 - 1) / n3 : (n2 - n + n3 + 1) / n3;
        if (n4 <= 0) {
            return new PyList();
        }
        PyObject[] pyObjectArray = new PyObject[n4];
        int n5 = n;
        for (int i = 0; i < n4; ++i) {
            pyObjectArray[i] = Py.newInteger(n5);
            n5 += n3;
        }
        return new PyList(pyObjectArray);
    }

    public static PyObject range(int n) {
        return __builtin__.range(0, n, 1);
    }

    public static PyObject range(int n, int n2) {
        return __builtin__.range(n, n2, 1);
    }

    private static PyString readline(PyObject pyObject) {
        if (pyObject instanceof PyFile) {
            return new PyString(((PyFile)pyObject).readline());
        }
        PyObject pyObject2 = pyObject.invoke("readline");
        if (!(pyObject2 instanceof PyString)) {
            throw Py.TypeError("object.readline() returned non-string");
        }
        return (PyString)pyObject2;
    }

    public static String raw_input(PyObject pyObject) {
        Py.print(pyObject);
        PyObject pyObject2 = Py.getSystemState().stdin;
        String string = __builtin__.readline(pyObject2).toString();
        if (string.endsWith("\n")) {
            return string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            throw Py.EOFError("raw_input()");
        }
        return string;
    }

    public static String raw_input() {
        return __builtin__.raw_input(new PyString(""));
    }

    public static PyObject reduce(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        PyObject pyObject4;
        PyObject pyObject5 = pyObject3;
        PyObject pyObject6 = Py.iter(pyObject2, "reduce() arg 2 must support iteration");
        while ((pyObject4 = pyObject6.__iternext__()) != null) {
            if (pyObject5 == null) {
                pyObject5 = pyObject4;
                continue;
            }
            pyObject5 = pyObject.__call__(pyObject5, pyObject4);
        }
        if (pyObject5 == null) {
            throw Py.TypeError("reduce of empty sequence with no initial value");
        }
        return pyObject5;
    }

    public static PyObject reduce(PyObject pyObject, PyObject pyObject2) {
        return __builtin__.reduce(pyObject, pyObject2, null);
    }

    public static PyObject reload(PyModule pyModule) {
        return imp.reload(pyModule);
    }

    public static PyObject reload(PyJavaClass pyJavaClass) {
        return imp.reload(pyJavaClass);
    }

    public static PyString repr(PyObject pyObject) {
        return pyObject.__repr__();
    }

    public static PyFloat round(double d, int n) {
        boolean bl = d < 0.0;
        double d2 = Math.pow(10.0, n);
        if (bl) {
            d = -d;
        }
        double d3 = Math.floor(d * d2 + 0.5);
        if (bl) {
            d3 = -d3;
        }
        return new PyFloat(d3 / d2);
    }

    public static PyFloat round(double d) {
        return __builtin__.round(d, 0);
    }

    public static void setattr(PyObject pyObject, String string, PyObject pyObject2) {
        pyObject.__setattr__(string, pyObject2);
    }

    public static PySlice slice(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        return new PySlice(pyObject, pyObject2, pyObject3);
    }

    public static PySlice slice(PyObject pyObject, PyObject pyObject2) {
        return __builtin__.slice(pyObject, pyObject2, Py.None);
    }

    public static PySlice slice(PyObject pyObject) {
        return __builtin__.slice(Py.None, pyObject, Py.None);
    }

    public static PyObject sum(PyObject pyObject, PyObject pyObject2) {
        PyObject pyObject3;
        if (pyObject2 instanceof PyString) {
            throw Py.TypeError("sum() can't sum strings [use ''.join(seq) instead]");
        }
        PyObject pyObject4 = pyObject.__iter__();
        while ((pyObject3 = pyObject4.__iternext__()) != null) {
            pyObject2 = pyObject2._add(pyObject3);
        }
        return pyObject2;
    }

    public static PyObject sum(PyObject pyObject) {
        return __builtin__.sum(pyObject, Py.Zero);
    }

    public static PyTuple tuple(PyObject pyObject) {
        if (pyObject instanceof PyTuple) {
            return (PyTuple)pyObject;
        }
        if (pyObject instanceof PyList) {
            PyList pyList = (PyList)pyObject;
            PyObject[] pyObjectArray = new PyObject[pyList.size()];
            System.arraycopy(pyList.getArray(), 0, pyObjectArray, 0, pyObjectArray.length);
            return new PyTuple(pyObjectArray);
        }
        return new PyTuple(Py.make_array(pyObject));
    }

    public static PyType type(PyObject pyObject) {
        return pyObject.getType();
    }

    public static PyObject vars(PyObject pyObject) {
        try {
            return pyObject.__getattr__("__dict__");
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.AttributeError)) {
                throw Py.TypeError("vars() argument must have __dict__ attribute");
            }
            throw pyException;
        }
    }

    public static PyObject vars() {
        return __builtin__.locals();
    }

    public static PyObject xrange(int n, int n2, int n3) {
        return new PyXRange(n, n2, n3);
    }

    public static PyObject xrange(int n) {
        return __builtin__.xrange(0, n, 1);
    }

    public static PyObject xrange(int n, int n2) {
        return __builtin__.xrange(n, n2, 1);
    }

    public static PyObject zip(PyObject[] pyObjectArray) {
        int n = pyObjectArray.length;
        if (n < 1) {
            throw Py.TypeError("zip requires at least one sequence");
        }
        PyObject[] pyObjectArray2 = new PyObject[n];
        for (int i = 0; i < n; ++i) {
            PyObject pyObject = pyObjectArray[i].__iter__();
            if (pyObject == null) {
                throw Py.TypeError("zip argument #" + (i + 1) + " must support iteration");
            }
            pyObjectArray2[i] = pyObject;
        }
        PyList pyList = new PyList();
        int n2 = 0;
        while (true) {
            PyObject[] pyObjectArray3 = new PyObject[n];
            for (int i = 0; i < n; ++i) {
                PyObject pyObject;
                try {
                    pyObject = pyObjectArray2[i].__iternext__();
                }
                catch (PyException pyException) {
                    if (Py.matchException(pyException, Py.StopIteration)) {
                        return pyList;
                    }
                    throw pyException;
                }
                if (pyObject == null) {
                    return pyList;
                }
                pyObjectArray3[i] = pyObject;
            }
            pyList.append(new PyTuple(pyObjectArray3));
            ++n2;
        }
    }

    public static PyObject __import__(String string) {
        return __builtin__.__import__(string, null, null, null);
    }

    public static PyObject __import__(String string, PyObject pyObject) {
        return __builtin__.__import__(string, pyObject, null, null);
    }

    public static PyObject __import__(String string, PyObject pyObject, PyObject pyObject2) {
        return __builtin__.__import__(string, pyObject, pyObject2, null);
    }

    public static PyObject __import__(String string, PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        PyObject pyObject4;
        PyFrame pyFrame = Py.getFrame();
        if (pyFrame == null) {
            return null;
        }
        PyObject pyObject5 = pyFrame.f_builtins;
        if (pyObject5 == null) {
            Py.getSystemState();
            pyObject5 = PySystemState.builtins;
        }
        if ((pyObject4 = pyObject5.__finditem__("__import__")) == null) {
            return null;
        }
        PyObject pyObject6 = pyObject4.__call__(new PyObject[]{Py.newString(string), pyObject, pyObject2, pyObject3});
        return pyObject6;
    }

    static {
        __doc__zip = new PyString("zip(seq1 [, seq2 [...]]) -> [(seq1[0], seq2[0] ...), (...)]\n\nReturn a list of tuples, where each tuple contains the i-th element\nfrom each of the argument sequences.  The returned list is\ntruncated in length to the length of the shortest argument sequence.");
    }
}

